<?php
 namespace Moto\Update; use Moto; use Moto\Update; class Core extends Moto\AbstractClass { const TYPE_ENGINE = 'ENGINE'; const TYPE_THEME = 'THEME'; const TYPE_PLUGIN = 'PLUGIN'; protected $_options = array( 'releaseFile' => 'release.zip', 'actionTimeout' => 250000, ); protected $_errors = array(); protected $_logs = array(); protected $_archive = null; protected $_archiveOpened = null; protected $_cache = array(); protected $_type = 'engine'; protected $_updateItem; protected $_dryRun; public function init() { $this->_dryRun = Moto\Config::get('__DEV__.Updater.dryRun'); } public function setUpdateItem($update) { $this->_updateItem = $update; $this->_onSetUpdateItem(); } protected function _onSetUpdateItem() { } public function getUpdateItem($key = null, $default = null) { if ($key === null) { return $this->_updateItem; } return Moto\Util::getValue($this->_updateItem, $key, $default); } protected function _addLog($action, $status) { if (is_array($status)) { $this->_logs[] = array($action, $status); } else { $this->_logs[] = $action . '.' . $status; } return $this; } public function getLogs() { return $this->_logs; } public function execute() { $this->_type = 'engine'; $this->_addLog(__FUNCTION__, 'start'); $debug = array( 't' => microtime(1) ); $debug['l'] = microtime(1); $this->checkRequirements(); $debug['checkRequirements'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_unzipArchive(); $debug['_unzipArchive'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_testFiles(); $debug['_testFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_backupFiles(); $debug['_backupFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_setMaintenanceMode(true); $debug['_setMaintenanceMode'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); if ($this->_applyFiles()) { $debug['_applyFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_preCheck(); $debug['_preCheck'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_doUpgrade(); $debug['_doUpgrade'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_postCheck(); $debug['_postCheck'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); } if ($this->isError()) { $this->_restoreFiles(); $debug['_restoreFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); } $this->_dropCache(); $debug['_dropCache'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_rebuild(); $debug['_rebuild'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_setMaintenanceMode(false); $debug['_setMaintenanceMode'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_finish(); $debug['_finish'] = microtime(1) - $debug['l']; $debug['all'] = microtime(1) - $debug['t']; $this->_addLog(__FUNCTION__, 'finish'); return !$this->isError(); } public function checkRequirements() { $result = true; if (!class_exists('ZipArchive')) { $this->_throwError(array('name' => 'CLASS_NOT_EXISTS', 'params' => array('class' => 'ZipArchive')), 'checkRequirements'); } $archiveFilePath = $this->getArchiveAbsolutePath(); if (file_exists($archiveFilePath)) { if (!is_readable($archiveFilePath)) { $this->_throwError(array('name' => 'ARCHIVE_NOT_READABLE', 'params' => array('path' => $this->getArchiveRelativePath())), 'checkRequirements'); } $zip = new \ZipArchive(); $isOpened = $zip->open($archiveFilePath); if ($isOpened === true) { $zip->getStatusString(); } else { $this->_throwError(array('name' => 'ARCHIVE_ERROR', 'params' => array('code' => $isOpened)), 'checkRequirements'); } } else { $this->_throwError(array('name' => 'ARCHIVE_NOT_EXISTS', 'params' => array('path' => $this->getArchiveRelativePath())), 'checkRequirements'); } $this->_addLog(__FUNCTION__, 'todo'); $this->_addLog(__FUNCTION__, 'success'); return $result; } public function getArchiveAbsolutePath() { $archivePath = trim($this->getUpdateItem('archivePath', '')); if (!empty($archivePath)) { return Moto\System::getAbsolutePath($archivePath); } if ($this->getOption('theme', false)) { $archiveFilePath = Moto\System::getAbsolutePath('@updateTemp/' . $this->getOption('theme') . $this->getOption('themeSuffix')); } else { $archiveFilePath = Moto\System::getAbsolutePath('@updateTemp/' . $this->getOption('releaseFile')); } return $archiveFilePath; } public function getArchiveRelativePath() { $archivePath = trim($this->getUpdateItem('archivePath', '')); if (!empty($archivePath)) { return Moto\System::getRelativePath($archivePath); } if ($this->getOption('theme', false)) { $archiveFilePath = Moto\System::getRelativePath('@updateTemp/' . $this->getOption('theme') . $this->getOption('themeSuffix')); } else { $archiveFilePath = Moto\System::getRelativePath('@updateTemp/' . $this->getOption('releaseFile')); } return $archiveFilePath; } public function getUpdateDir($addBaseDir = true, $themeDir = null) { $archiveFilePath = $this->getArchiveAbsolutePath(); $info = pathinfo($archiveFilePath); $dir = $info['dirname'] . '/' . $info['filename']; if ($addBaseDir && is_dir($dir . '/site')) { $dir .= '/site'; } if (isset($themeDir) && is_dir($dir . '/' . $themeDir)) { $dir .= '/' . $themeDir; } return $dir; } public function getArchive() { if (null == $this->_archive) { $archiveFilePath = $this->getArchiveAbsolutePath(); $this->_archive = new \ZipArchive(); $this->_archiveOpened = $this->_archive->open($archiveFilePath); } return $this->_archive; } protected function _unzipArchive() { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } $archive = $this->getArchive(); if ($this->_archiveOpened !== true) { $this->addError(array('name' => 'ARCHIVE_ERROR', 'params' => array('code' => $this->_archiveOpened)), 'unzipArchive'); return false; } $dir = $this->getUpdateDir(false); if (file_exists($dir)) { Moto\Util::emptyDir($dir); } else { Moto\Util::createDir($dir); } if (!is_writable($dir)) { $this->addError(array('name' => 'DIR_NOT_WRITABLE', 'params' => array('path' => $dir)), 'unzipArchive'); return false; } $status = $archive->extractTo($dir); if (!$status) { $this->addError(array('name' => 'ARCHIVE_NOT_EXTRACTED', 'params' => array('path' => $this->getArchiveRelativePath())), 'unzipArchive'); return false; } $this->_addLog(__FUNCTION__, 'todo'); $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _getDestinationPath() { if ($this->getOption('theme', false)) { $rootPath = Moto\System::getAbsolutePath('@themes/' . $this->getOption('theme')); } else { $rootPath = Moto\Config::get('rootPath'); } return $rootPath; } protected function _getUpdateSourceDir() { if ($this->getOption('theme', false)) { $dir = $this->getUpdateDir(false, $this->getOption('theme')); } else { $dir = $this->getUpdateDir(); } return $dir; } protected function _testFiles() { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } $this->_addLog(__FUNCTION__, 'start'); $rootPath = $this->_getDestinationPath(); $dir = $this->_getUpdateSourceDir(); if ($this->getOption('theme', false)) { if (!Moto\Application\Themes\Service::_isValidTheme($dir)) { $this->addError(array('name' => 'THEME_NOT_VALID', 'params' => array('path' => $dir)), 'testFiles'); return false; } } $files = Moto\Util::scanDir($dir); $this->_cache['updateFiles'] = $files; $result = array( 'status' => true, 'errors' => array( 'notReadable' => array(), 'notWritable' => array(), 'notCreatable' => array() ) ); for ($i = 0, $count = count($files); $i < $count; $i++) { $relativePath = $files[$i]; $from = $dir . '/' . $relativePath; $to = $rootPath . '/' . $relativePath; $toDir = null; if (is_file($from)) { if (!is_readable($from)) { $result['errors']['notReadable'][] = $relativePath; } if (is_file($to) && !is_writable($to)) { $result['errors']['notWritable'][] = $relativePath; continue; } if (!file_exists($to)) { $toDir = dirname($to); } } if (is_dir($from)) { $toDir = $to; } if (null !== $toDir) { if (is_dir($toDir)) { if (!is_writable($toDir)) { $result['errors']['notWritable'][] = $relativePath; } } else { if (Moto\Util::createDir($toDir)) { Moto\Util::deleteDir($toDir); } else { $result['errors']['notCreatable'][] = $relativePath; } } } } $result['status'] = (empty($result['errors']['notReadable']) && empty($result['errors']['notWritable']) && empty($result['errors']['notCreatable'])); if (!$result['status']) { if (empty($result['errors']['notReadable'])) { unset($result['errors']['notReadable']); } if (empty($result['errors']['notWritable'])) { unset($result['errors']['notWritable']); } if (empty($result['errors']['notCreatable'])) { unset($result['errors']['notCreatable']); } $this->_addLog(__FUNCTION__, 'error'); $this->addError(array('name' => 'APPLY_CANT_COPY', 'params' => $result['errors']), 'testFiles'); return false; } $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _backupFiles() { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } $this->_addLog(__FUNCTION__, 'todo'); $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _setMaintenanceMode($mode) { if ($mode) { Moto\Website\MaintenanceMode::turnOn(); } else { Moto\Website\MaintenanceMode::turnOff(); } return true; } protected function _restoreFiles() { $this->_addLog(__FUNCTION__, 'todo'); $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _dropCache() { $this->_addLog(__FUNCTION__, 'start'); Moto\Hook::trigger(Moto\Hook::CACHE_CLEAN); $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _rebuild() { $this->_addLog(__FUNCTION__, 'todo'); Moto\System\Style::rebuildAll(); $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _applyFiles($files = array()) { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } $this->_addLog(__FUNCTION__, 'start'); $rootPath = $this->_getDestinationPath(); $dir = $this->_getUpdateSourceDir(); if (empty($files)) { $files = $this->_getFilesForUpdates(); } $result = Moto\Util::copyFiles($files, $dir, $rootPath); if (!$result) { $this->_addLog(__FUNCTION__, 'error'); $this->addError(array('name' => 'APPLY_NOT_COPIED'), 'applyFiles'); return false; } $this->_addLog(__FUNCTION__, 'success'); return true; } protected function _preCheck() { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } try { $result = Update\Requirements::preCheck(); if ($result) { $this->_addLog(__FUNCTION__, 'success'); } else { $this->_addLog(__FUNCTION__, 'error'); $this->addErrors(Update\Requirements::getErrors(), 'Requirements.preCheck'); } } catch (\Exception $e) { $this->_addLog(__FUNCTION__, 'exception'); $this->addErrors(Update\Requirements::getErrors(), 'Requirements.preCheck'); $result = false; } $this->_addLog(__FUNCTION__, 'todo'); $this->_addLog(__FUNCTION__, 'success'); return $result; } protected function _doUpgrade() { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } if (!class_exists('Moto\Update\Upgrade')) { $this->_throwError(array('name' => 'CLASS_NOT_EXISTS', 'params' => array('class' => 'Moto\\Update\\Upgrade')), 'updateDatabase'); } try { $target = new \ReflectionClass(Moto\Update\Upgrade::class); $filePath = $target->getFileName(); $fileInfo = [ 'size' => number_format(filesize($filePath)), 'md5' => md5_file($filePath), 'sha1' => sha1_file($filePath), ]; $toBuild = (int) $this->getUpdateItem('build'); if (Update\Upgrade::BUILD < $toBuild) { Moto\System\Log::critical('UPDATER : Try to update from ' . Moto\Version::getCurrentBuild() . ' to ' . $toBuild . ' but "Upgrade" migration has build ' . Update\Upgrade::BUILD, $fileInfo); if (class_exists(Moto\System\Cache\Cleaner::class)) { $this->info('Drop system cache ', Moto\System\Cache\Cleaner::systemCache()); } throw new \RuntimeException('CANT_UPGRADE'); } $this->info('Execute "Upgrade" from ' . Moto\Version::getCurrentBuild() . ' to ' . Update\Upgrade::BUILD, $fileInfo); $result = Update\Upgrade::execute(); if ($result) { $this->_addLog(__FUNCTION__, 'success'); } else { $this->_addLog(__FUNCTION__, 'error'); $this->addErrors(Update\Upgrade::getErrors(), 'Upgrade.execute'); } } catch (\Exception $e) { $this->_addLog(__FUNCTION__, 'exception'); Update\Upgrade::addError($e->getMessage()); $this->addErrors(Update\Upgrade::getErrors(), 'Upgrade.execute'); $result = false; } $this->_addLog(__FUNCTION__, 'todo'); $this->_addLog(__FUNCTION__, 'success'); return $result; } protected function _postCheck() { if ($this->isError()) { $this->_addLog(__FUNCTION__, 'skipped'); return false; } try { $result = Update\Requirements::postCheck(); if ($result) { $this->_addLog(__FUNCTION__, 'success'); } else { $this->_addLog(__FUNCTION__, 'error'); $this->addErrors(Update\Requirements::getErrors(), 'Requirements.postCheck'); } } catch (\Exception $e) { $this->_addLog(__FUNCTION__, 'exception', $e); $this->addErrors(Update\Requirements::getErrors(), 'Requirements.postCheck'); $result = false; } $this->_addLog(__FUNCTION__, 'todo'); return $result; } protected function _finish() { if ($this->_archive != null && $this->_archiveOpened) { $this->_archive->close(); } $dir = $this->getUpdateDir(false); if (is_dir($dir)) { Moto\Util::deleteDir($dir); } return true; } public function getErrors() { return $this->_errors; } public function addErrors($errors, $dispatcher = 'core') { for ($i = 0, $count = count($errors); $i < $count; $i++) { $this->addError($errors[$i], $dispatcher); } } public function addError($error, $sender = null) { if (!is_array($error)) { $error = array($error); } if (empty($error['type'])) { $error['type'] = $this->getType(); } $message = 'UPDATER.' . strtoupper($this->getType()) . ': '; $message .= Moto\Util::getValue($error, 'name', ''); if (!is_string($sender)) { $sender = Moto\Util::getValue($error, 'sender', null); } if (is_string($sender)) { $message .= ' by ' . $sender; } Moto\System\Log::error($message, $error); $this->_errors[] = $error; } protected function _throwError($error, $sender = null) { $this->addError($error, $sender); throw new \Exception(Moto\Util::getValue($error, 'name', 'FAILED')); } public function isError() { return count($this->_errors); } public function getType() { return $this->_type; } protected function _getFilesForUpdates($rescan = false) { if ($rescan || empty($this->_cache['updateFiles'])) { $dir = $this->getUpdateDir(); $files = Moto\Util::scanDir($dir); $this->_cache['updateFiles'] = $files; } return $this->_cache['updateFiles']; } protected function info($message, $data = []) { Moto\System\Log::info('UPDATER.' . strtoupper($this->getType()) . ' : ' . $message, $data); } public function executeAction($action, $params = []) { $timestamp = microtime(1); $logMessagePrefix = 'UPDATER.' . strtoupper($this->getType()); $result = null; $method = $this->getActionMethodName($action); if (method_exists($this, $method)) { $logMessagePrefix .= ' [ ' . $action . ' ]'; Moto\System\Log::info($logMessagePrefix . ' start ', array( 'action' => $action, 'current' => Moto\Version::getCurrentBuild(), 'params' => $params, )); if (is_callable($this->_dryRun)) { $result = call_user_func($this->_dryRun, $this, $method, $params, $action); } else { $result = $this->{$method}($params, $action); } } else { $this->_throwError(array( 'name' => 'UNKNOWN_ACTION', 'action' => $action, '$method' => $method, 'params' => $params, )); } $executionTime = microtime(1) - $timestamp; if ($this->isError()) { Moto\System\Log::error($logMessagePrefix . ' failed after ' . $executionTime . ' s'); throw new \Exception('UPDATER.HAS_ERROR'); } Moto\System\Log::info($logMessagePrefix . ' done after ' . $executionTime . ' s'); $this->_afterExecuteAction($action, $params); return $result; } protected function _afterExecuteAction($action, $params = null) { $timeout = $this->getOption('actionTimeout'); if (is_int($timeout) && $timeout > 0) { usleep($timeout); } } public function getActionMethodName($name) { if ($name[0] === '@') { return 'processCustomAction'; } return 'process' . Moto\Util::toStudlyCase(Moto\Util::toSnakeCase($name)) . 'Action'; } public function hasActionMethod($name) { return method_exists($this, $this->getActionMethodName($name)); } public function processExtractArchiveAction($params = null) { if (!class_exists('ZipArchive')) { $this->_throwError(array('name' => 'CLASS_NOT_EXISTS', 'params' => array('class' => 'ZipArchive')), 'extractArchive'); } $archiveFilePath = $this->getArchiveAbsolutePath(); if (file_exists($archiveFilePath)) { if (!is_readable($archiveFilePath)) { $this->_throwError(array('name' => 'ARCHIVE_NOT_READABLE', 'params' => array('path' => $this->getArchiveRelativePath())), 'extractArchive'); } } else { $this->_throwError(array('name' => 'ARCHIVE_NOT_EXISTS', 'params' => array('path' => $this->getArchiveRelativePath())), 'extractArchive'); } $this->info('Archive => ', [ 'path' => $this->getArchiveRelativePath(), 'size' => number_format(filesize($archiveFilePath)), 'md5' => md5_file($archiveFilePath), 'sha1' => sha1_file($archiveFilePath), ]); $this->_unzipArchive(); return !$this->isError(); } public function getNextRequest($action, $params) { return array( 'params' => array( 'timestamp' => time(), ) ); } public function processCheckRequirementsAction($params = null) { $this->checkRequirements(); return !$this->isError(); } public function processCheckFilesAction($params = null) { $this->_testFiles(); return !$this->isError(); } public function processEnableMaintenanceAction($params = null) { $this->_setMaintenanceMode(true); return !$this->isError(); } public function processCreateBackupAction($params = null) { return !$this->isError(); } public function processUpdateFilesAction($params = null) { $this->_throwError(array('name' => 'ACTION_NOT_IMPLEMENTED', 'params' => array('class' => get_class($this))), 'updateFiles'); return !$this->isError(); } public function processClearSystemCacheAction($params = null) { $this->info('Clean system cache...'); $dir = $this->_getUpdateSourceDir(); $files = Moto\Util::scanDir($dir, '', [ 'compareFunction' => function ($dir, $file) { return strpos($file, '.php') > 0; }, ] ); $prefix = Moto\System::getAbsolutePath('@website'); foreach ($files as $index => $path) { $files[$index] = $prefix . '/' . $path; } $this->info('First run for ' . (count($files) > 0 ? count($files) : 'all') . ' files'); if (count($files) > 0) { Moto\System\Cache\Cleaner::systemCacheFor($files); } else { Moto\System\Cache\Cleaner::systemCache(); } sleep(5); $this->info('Second run for ' . (count($files) > 0 ? count($files) : 'all') . ' files'); if (count($files) > 0) { Moto\System\Cache\Cleaner::systemCacheFor($files); } else { Moto\System\Cache\Cleaner::systemCache(); } $this->info('System cache cleaned'); return !$this->isError(); } public function processUpdateDatabaseAction($params = null) { $this->_throwError(array('name' => 'ACTION_NOT_IMPLEMENTED', 'params' => array('class' => get_class($this))), 'updateDatabase'); return false; } public function processRestoreBackupAction($params = null) { return !$this->isError(); } public function processCleanCacheAction($params = null) { $this->_dropCache(); return !$this->isError(); } public function processOptimizeStylesAction($params = null) { $options = array( 'isDebug' => Moto\System::isDevelopmentStage(), ); $options['type'] = 'header'; Moto\Application\Content\Util::compressContainers($options); $options['type'] = 'content'; Moto\Application\Content\Util::compressContainers($options); $options['type'] = 'footer'; Moto\Application\Content\Util::compressContainers($options); return !$this->isError(); } public function processRebuildStylesAction($params = null) { Moto\System\Style::rebuildAll(true); return !$this->isError(); } public function processDisableMaintenanceAction($params = null) { $this->_setMaintenanceMode(false); return !$this->isError(); } public function processFinishUpdateAction($params = null) { $this->_finish(); $archiveFilePath = $this->getArchiveAbsolutePath(); if (file_exists($archiveFilePath)) { @unlink($archiveFilePath); } return !$this->isError(); } public function processSaveCurrentBuildAction($params = null) { return true; } public function processCancelingAction($params) { return true; } } 