<?php
 namespace Moto\Update; use Moto; class UpdaterTheme extends Core { protected $_updateItem; public function init() { $this->_type = static::TYPE_THEME; parent::init(); } protected function _checkOptionsBeforeExecuting() { $invalidOptions = array(); if (!array_key_exists('theme', $this->_options) || !is_string($this->_options['theme']) || $this->_options['theme'] === '') { $invalidOptions[] = 'name'; } if (!array_key_exists('themeSuffix', $this->_options) || !is_string($this->_options['themeSuffix']) || $this->_options['themeSuffix'] === '') { $invalidOptions[] = 'themeSuffix'; } if (count($invalidOptions)) { $this->_throwError(array( 'name' => 'UPDATER_INVALID_OPTIONS', 'options' => $invalidOptions, )); } } public function getArchiveAbsolutePath() { $archivePath = trim($this->getUpdateItem('archivePath', '')); if (!empty($archivePath)) { return Moto\System::getAbsolutePath($archivePath); } return Moto\System::getAbsolutePath('@updateTemp/' . $this->getOption('theme') . $this->getOption('themeSuffix')); } public function getArchiveRelativePath() { $archivePath = trim($this->getUpdateItem('archivePath', '')); if (!empty($archivePath)) { return Moto\System::getRelativePath($archivePath); } return Moto\System::getRelativePath('@updateTemp/' . $this->getOption('theme') . $this->getOption('themeSuffix')); } protected function _getDestinationPath() { return Moto\System::getAbsolutePath('@themes/' . $this->getOption('theme')); } protected function _getUpdateSourceDir() { return $this->getUpdateDir(false, $this->getOption('theme')); } public function execute() { $this->_checkOptionsBeforeExecuting(); $debug = array( 't' => microtime(1) ); $this->_addLog(__FUNCTION__, 'start'); $debug = array( 't' => microtime(1) ); $debug['l'] = microtime(1); $this->checkRequirements(); $debug['checkRequirements'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_unzipArchive(); $debug['_unzipArchive'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_testFiles(); $debug['_testFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $fileIndex = array_search('theme.json', $this->_cache['updateFiles']); $settingsFile = $this->_cache['updateFiles'][$fileIndex]; unset($this->_cache['updateFiles'][$fileIndex]); $this->_applyFiles(); $debug['_applyFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_cache['updateFiles'] = array($settingsFile); $this->_applyFiles(); $debug['_applyFiles'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $theme = $this->getOption('theme'); if ($theme == Moto\Website\Settings::get('theme')) { $this->updateThemeSettings($theme); } $this->_dropCache(); $debug['_dropCache'] = microtime(1) - $debug['l']; $debug['l'] = microtime(1); $this->_finish(); $debug['_finish'] = microtime(1) - $debug['l']; $debug['all'] = microtime(1) - $debug['t']; $this->_addLog(__FUNCTION__, 'finish'); return !$this->isError(); } public function updateThemeSettings($theme) { Moto\Features::disableByMask('theme'); Moto\Website\Theme::importFeatures($theme); Moto\Website\Theme::importSpacings($theme, 'update'); if (method_exists('Moto\Website\Theme', 'importGridOptions')) { Moto\Website\Theme::importGridOptions($theme, 'update'); } Moto\Website\Theme::importHeadingSpacings($theme, 'update'); Moto\Website\Theme::importPresetsEditKeys($theme); Moto\Website\Theme::importPresets($theme, 'update'); Moto\Website\Theme::importTextStyles($theme, 'update'); if ((bool) Moto\Features::isEnabled('theme_customized_lists_styles')) { $options = [ 'properties' => [ 'desktop.base.^ul li&', 'desktop.base.^ol li&', 'tablet.base.^ul li&', 'tablet.base.^ol li&', 'mobile-h.base.^ul li&', 'mobile-h.base.^ol li&', 'mobile-v.base.^ul li&', 'mobile-v.base.^ol li&', ] ]; Moto\Website\Theme::updateTextStylesFromNormal($options); } Moto\Website\Theme::importContentSections($theme); $this->_rebuild(); return true; } public function processComplexUpdateAction($params = null) { $this->setOption('theme', Moto\Util::getValue($params, 'name')); $this->setOption('themeSuffix', '_latest.zip'); return $this->execute(); } public function getUpdateItem($key = null, $default = null) { return parent::getUpdateItem($key, $default); } protected function _onSetUpdateItem() { parent::_onSetUpdateItem(); $item = Moto\Application\Updates\ThemeUpdateItem::factory($this->_updateItem); if (!$item) { throw new \Exception('Cant create "ThemeUpdateItem"'); } $this->_updateItem = $item; } public function getNextRequest($action, $params) { return null; } public function processSelfExecutionAction($params) { $item = $this->getUpdateItem(); try { return $item->selfExecute(); } catch (\Exception $e) { if ($e instanceof Moto\System\Exception) { $this->addErrors($e->getErrors(), $this->getType()); } else { $error = [ 'name' => 'THEME_UPDATE_EXECUTING_STEP_FAILED', 'params' => [ 'step' => $item->step, ], ]; $this->_throwError($error); } } } public function processCancelingAction($params) { $item = $this->getUpdateItem(); try { return $item->cancelUpdate(); } catch (\Exception $e) { if ($e instanceof Moto\System\Exception) { $this->addErrors($e->getErrors(), $this->getType()); } else { $error = [ 'name' => 'THEME_UPDATE_EXECUTING_STEP_FAILED', 'params' => [ 'step' => $item->step, ], ]; $this->_throwError($error); } } } } 