/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

angular.module('application.widget.store.widget', ['application.core'])
    .config(['core.library.editor.WidgetsServiceProvider',
        'motoWidgetsWhiteListProvider',
        function (WidgetsServiceProvider,motoWidgetsWhiteListProvider) {
            WidgetsServiceProvider.addCategory ('store', 'Store');
            motoWidgetsWhiteListProvider.add('tabs', [
                'store_product_add_to_cart',
                'store_product_add_to_compare',
                'store_product_name',
                'store_product_price',
                'store_product_quantity',
                'store_product_short_description',
                'store_product_description',
                'store_product_media_gallery',
                'store_product_rating',
                'store_product_reviews',
                'store_product_properties',
                'store_product_related_products',
                'store_product_video'
            ]);
            /**
             * Register Batch Grid Filter
             */
            swig.setFilter('batch', function (input, args) {

                var batched = [];
                var batchSize = parseInt(args);

                if (input.length > 0)
                {
                    var i,j,chunk;

                    for (i=0,j=input.length; i<j; i+=batchSize)
                    {
                        chunk = input.slice(i,i+batchSize);

                        batched.push(chunk);
                    }
                }
                return batched;
            });

            /**
             * Price Filter placeholder
             */
            swig.setFilter('price', function (input) {

                return '$' + input;
            });

            /**
             * Price Filter placeholder
             */
            swig.setFilter('merge', function (input) {

                return input;
            });

            swig.setFilter('translate', function (input) {

                return input;
            });
        }]);
