<?php
namespace Website\Widgets\StoreAccount;

use Moto;
use MotoStore\Content\Controller\AccountController;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_account';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        )
    );
    public function getRenderVariables()
    {
        $controller = new AccountController ();

        return array (
            'currentWidget' => $this,
            'accountPageContent' => $controller->renderAccountPage ($this)
        );

    }


    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}