<?php
namespace Website\Widgets\StoreBreadcrumbs;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Product\Entity\Category;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Repository\CategoryRepository;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_breadcrumbs';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'home' => array(
            'text' => 'Home'
        ),
    );
    /**
     * @var array
     */
    public $breadcrumbs = array ();

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }

    /**
     * Create breadcrumbs by section
     */
    protected function buildBreadcrumbs ()
    {
        $uri = Link::getEntityUri (Link::URI_SECTION_PRODUCT);

        if ($uri)
        {
            $this->breadcrumbs =  $this->getProductBreadcrumbs ($uri);
        }

        if ($uri = Link::getEntityUri (Link::URI_SECTION_CATEGORY))
        {
            $this->breadcrumbs = $this
                ->getCategoryBreadcrumbs ($this->getCategory ($uri));
        }
    }

    /**
     * @return array
     */
    public function getRenderVariables()
    {
        if (!Moto\Website\Application::getInstance()->isPreviewMode()) {
            $this->buildBreadcrumbs();
        } else {
            $this->breadcrumbs = array(array('title' => 'Lorem Ipsum'), array('title' => 'Lorem Ipsum'));
        }
        return array('currentWidget' => $this);
    }

    /**
     * @param $uri
     * @return array
     */
    protected function getProductBreadcrumbs ($uri)
    {
        $breadcrumbs = array ();

        /** @var Product $product */
        $product = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->getProduct ($uri);

        if ($product)
        {
            /** @var Category $category */
            if ($product->getPrimaryCategoryId()){
                $category = SMStatic::getInstance ()
                    ->get ('MotoStore\EntityManager')
                    ->getRepository ('MotoStore\Product\Entity\Category')
                    ->getCategoryById ($product->getPrimaryCategoryId());
            } else {
                $category       =  $product->getCategories ()->first ();
            }

            $breadcrumbs    = $this->getCategoryBreadcrumbs ($category);

            $breadcrumbs [] = array (
                'title' => $product->getLocaleByLanguageCode ('en')->getName (),
                'link'  => Link::storeLink (Link::URI_SECTION_PRODUCT, $product->getUri ()),
            );
        }

        return $breadcrumbs;
    }

    /**
     * @param $category
     * @return array
     */
    protected function getCategoryBreadcrumbs ($category)
    {
        if ($category)
        {
            /** @var CategoryRepository $repository */
            $repository = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Category');

            return $repository->getBreadcrumbs ($category);
        }
        return array ();
    }

    /**
     * @param $uri
     * @return Category|null|object
     */
    protected function getCategory ($uri)
    {
        /** @var CategoryRepository $repository */
        $repository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Category');

        /** @var Category $category */
        return $repository->getCategory ($uri);
    }
}
