'use strict';

angular.module('application.widget.store.breadcrumbs', ['application.core'])
    .run([
        'coreLibraryWidget',
        'core.library.editor.WidgetsService',
        function(WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function StoreBreadcrumbsWidgetClass() {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    home: {
                        text: 'Home'
                    }
                };
                AbstractWidgetClass.apply(this, arguments);
            }
            StoreBreadcrumbsWidgetClass.prototype = Object.create(AbstractWidgetClass.prototype);
            StoreBreadcrumbsWidgetClass.prototype.constructor = StoreBreadcrumbsWidgetClass;
            StoreBreadcrumbsWidgetClass.prototype.name = 'store_breadcrumbs';
            StoreBreadcrumbsWidgetClass.prototype.label = 'EDITOR.WIDGETS.STORE_BREADCRUMBS.LABEL';
            StoreBreadcrumbsWidgetClass.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_breadcrumbs/views/properties.tpl.html';
            StoreBreadcrumbsWidgetClass.prototype._apiVersion = 2;
            StoreBreadcrumbsWidgetClass.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_breadcrumbs/icons/drag-store-breadcrumbs.png';
            StoreBreadcrumbsWidgetClass.prototype._transformToMacros = true;
            StoreBreadcrumbsWidgetClass.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_breadcrumbs/presets/default/template.html.twig'
            };
            StoreBreadcrumbsWidgetClass.prototype.breadcrumbs = [{title: 'Lorem Ipsum'}, {title: 'Lorem Ipsum'}];
            StoreBreadcrumbsWidgetClass.prototype.getRenderVariables = function() {
                return {
                    currentWidget: this
                };
            };
            StoreBreadcrumbsWidgetClass.prototype._transformToMacros = true;
            StoreBreadcrumbsWidgetClass.prototype.isCopyable = function() {
                return true;
            };
            StoreBreadcrumbsWidgetClass.prototype.shouldUpdateContentView = function() {
                return true;
            };
            WidgetFactory.set(StoreBreadcrumbsWidgetClass.prototype.name, StoreBreadcrumbsWidgetClass);
            WidgetsService.addWidget({
                name: StoreBreadcrumbsWidgetClass.prototype.name,
                label: StoreBreadcrumbsWidgetClass.prototype.label,
                category: "store",
                order: 5,
                allowed: function(page, sectionName) {
                    return [
                        "template.store.notexisting",
                    ].indexOf(page.type) !== -1 && sectionName === 'content';

                },
                icons: {
                    small: 'icon icon-store_breadcrumbs',
                    medium: '',
                    large: 'icon icon-store-breadcrumbs'
                }
            });

        }
    ]);
