'use strict';

angular.module('application.widget.store.cart_and_profile', ['application.widget.abstract'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');


            function Controller($scope, coreLibraryModal, coreLibraryUtils) {

                $scope.openItemPopup = function(item) {
                    var defaultItem = {
                        icon: null,
                        link: {
                            action: 'url',
                            properties: {
                                nofollow: false,
                                target: '_blank',
                                url: ''
                            }
                        },
                        advancedStylesEnabled: false,
                        advancedStyles: {
                            'desktop': {
                                'base': {
                                    'color': '',
                                    'background-color': '',
                                    'border-color': ''
                                },
                                'hover': {
                                    'color': '',
                                    'background-color': '',
                                    'border-color': ''
                                }
                            }
                        }
                    };

                    coreLibraryModal(
                        '@plugins/moto-store-plugin/app/widgets/store_cart_and_profile/views/item.tpl.html',
                        function($modalScope, $modalInstance) {
                            // `true` in case we are inside editing mode, `false` in case we are inside new item mode
                            $modalScope.editingMode = !!item;

                            $modalScope.item = ($modalScope.editingMode) ? angular.copy(item) : angular.copy(defaultItem);
                            $modalScope.ok = function() {
                                if ($modalScope.editingMode) {
                                    // update existing model if it was editing action
                                    angular.extend(item, $modalScope.item);
                                } else {
                                    // or add new item into model if it was adding new item action
                                    $scope.currentWidget.properties.items.push($modalScope.item);
                                }
                                $modalInstance.close($modalScope);
                            };
                            $modalScope.cancel = function() {
                                $modalInstance.close($modalScope);
                            };
                        }
                    );
                };



            }

            Controller.$inject = ['$scope', 'coreLibraryModal', 'coreLibraryUtils'];


            function classWidget () {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    widget_title: 'My Cart',
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    style: 'moto-text_normal',
                   items : [

                       {
                            "icon":{"provider":"FontAwesome","id":"shopping-cart","unicode":"f07a"},
                            "advancedStylesEnabled":false,
                        },
                        {
                            "icon":{"provider":"FontAwesome","id":"balance-scale","unicode":"f24e"},
                            "advancedStylesEnabled":false,
                        },
                        {
                            "icon": {"provider": "FontAwesome", "id": "heart", "unicode": "f004"},
                            "advancedStylesEnabled": false,
                        },
                        {
                            "icon":{"provider":"FontAwesome","id":"user","unicode":"f007"},
                            "advancedStylesEnabled":false,
                        },
                        {
                            "icon":{"provider":"FontAwesome","id":"sign-out","unicode":"f08b"},
                            "advancedStylesEnabled":false,
                        }

                        ]
                };
                AbstractWidgetClass.apply(this, arguments);

            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_cart_and_profile';
            classWidget.prototype.label = 'EDITOR.WIDGETS.CART_AND_PROFILE.LABEL';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_cart_and_profile/views/properties.tpl.html';
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype.controller = Controller;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_cart_and_profile/icons/drag-store-cart-and-profile.png';
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_cart_and_profile/presets/default/template.html.twig'
            };
            classWidget.prototype.customer = {
                first_name: 'John',
                last_name: 'Doe'
            };

            classWidget.prototype.getRenderVariables = function() {
                return {
                    currentWidget: this
                };
            };
            classWidget.prototype.isCopyable = function() {
                return true;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };
            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: classWidget.prototype.name,
                label: classWidget.prototype.label,
                category: "store",
                order: 5,
                enabled: true,
                icons: {
                    small: 'icon icon-store_cart-and-profile',
                    medium: '',
                    large: 'icon icon-store_cart-and-profile'
                }
            });
        }
    ]);

angular.module('application.widget.store.cart_and_profile')
    .controller('application.widget.store.cart_and_profile.controllers.ItemController', [
        '$scope',
        function($scope) {
            $scope.styleModel = {};

            $scope.$on('MotoUI.StateSwitcher.Changed', function(event, data) {
                $scope.setStyleModel(data);
            });
            function _patchArrayToObject(target) {
                var name;

                if (angular.isArray(target) || !angular.isObject(target)) {
                    return false;
                }

                for (name in target) {
                    if (!target.hasOwnProperty(name)) {
                        continue;
                    }
                    if (angular.isArray(target[name])) {
                        if (!target[name].length) {
                            //console.warn('found array', name, 'of', angular.copy(target));
                            target[name] = {};
                        } else {
                            //console.warn('found array', name, 'but ignored, by length = ', target[name].length);
                        }
                    } else if (angular.isObject(target[name])) {
                        _patchArrayToObject(target[name]);
                    }
                }

                return true;
            }

            $scope.setStyleModel = function(options) {
                var entitiesArray = options.entities.split(',');
                var i;

                for (i = 0; i < entitiesArray.length; i++) {
                    if (!$scope.item[entitiesArray[i]]) {
                        $scope.item[entitiesArray[i]] = {
                            desktop: {
                                base: {},
                                hover: {}
                            },
                            mobile: {
                                base: {},
                                hover: {}
                            }
                        };
                    }
                    if ($scope.item[entitiesArray[i]].desktop) {
                        $scope.styleModel[entitiesArray[i]] = $scope.item[entitiesArray[i]].desktop[options.value];
                    } else if ($scope.item[entitiesArray[i]].mobile) {
                        $scope.styleModel[entitiesArray[i]] = $scope.item[entitiesArray[i]].mobile[options.value];
                    }
                }
                $scope.$broadcast('widget.properties.setCache', $scope.currentCashKey);
                $scope.currentCashKey = options.entities + options.value;
                $scope.currentStyleOptions = options;
            };
            $scope.initEntities = function(entities, switcherState) {
                _patchArrayToObject($scope.item);
                $scope.setStyleModel({
                    entities: entities,
                    value: switcherState || 'base',
                    init: false
                });
            };
            $scope.resetEntities = function(entities, switcherState) {
                if (switcherState) {
                    $scope.setStyleModel({
                        entities: entities,
                        value: switcherState
                    });
                }
            };
            $scope.getParent = function(entity, pseudoElement) {
                if ($scope.currentStyleOptions.value === 'base') {
                    return null;
                } else {
                    return (pseudoElement) ? $scope.item[entity].desktop.base[pseudoElement] : $scope.item[entity].desktop.base;
                }
            };
            $scope.saveItem = function() {
                if (!$scope.editWidgetItem.$valid) {
                    return;
                }
                $scope.$parent.ok();
            };

        }]);
