<?php

namespace Website\Widgets\StoreCartAndProfile;

use Moto;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_cart_and_profile';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset' => 'default',
        'align' =>  array(
            "desktop"=> 'left',
            "tablet"=> '',
            "mobile-h"=> '',
            "mobile-v"=> ''
        ),
        'widget_title' => 'My Cart',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'style' => 'moto-text_normal'
    );
    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        return '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
    }
}
