
angular.module('StoreWebsite').service ('StoreWebsite.service.cart', [
    'jsonrpc',
    function (jsonrpc) {
        var service = jsonrpc.newService('store_cart_service');
        this.addItem    = service.createMethod('addItem');
        this.updateItem = service.createMethod('updateItem');
        this.removeItem = service.createMethod('removeItem');
        this.getCart    = service.createMethod('getCart');
        this.applyDiscount = service.createMethod('applyDiscount');
        this.setShippingMethod = service.createMethod('setShippingMethod');
    }
]);

angular.module('StoreWebsite').service ('StoreWebsite.service.compare', [
    'jsonrpc',
    function (jsonrpc) {
        var service = jsonrpc.newService('store_cart_service');
        this.addCompareItem    = service.createMethod('addCompareItem');
        this.removeCompareItem = service.createMethod('removeCompareItem');
        this.getCompare    = service.createMethod('getCompare');

    }
]);

angular.module('StoreWebsite').service ('StoreWebsite.service.wish', [
    'jsonrpc',
    function (jsonrpc) {
        var service = jsonrpc.newService('store_cart_service');
        this.addWishItem    = service.createMethod('addWishItem');
        this.removeWishItem = service.createMethod('removeWishItem');
        this.getList    = service.createMethod('getWishList');
    }
]);

angular.module('StoreWebsite').service('StoreWebsite.service.auth', [
    'jsonrpc',
    function (jsonrpc) {
        var service = jsonrpc.newService('store_customer_service');
        this.auth = service.createMethod('auth');
        this.register = service.createMethod('register');
        this.logout = service.createMethod('logout');
        this.current = service.createMethod('current');
    }
]);

angular.module('StoreWebsite').service ('StoreWebsite.service.country', [
    'jsonrpc',
    function (jsonrpc) {
        var service = jsonrpc.newService('store_country_service');
        this.getCollection = service.createMethod('getCollection');
    }
]);

angular.module('StoreWebsite').directive ('storeCartWidget', [
    'StoreWebsite.service.cart',
    'StoreWebsite.service.compare',
    'StoreWebsite.service.wish',
    'StoreWebsite.service.auth',
    function (cart, compare, wish, auth) {

        return {
            restrict: 'A',

            link: function ($scope, element, attributes) {

                $scope.widget = {
                    customer: null
                };
                $scope.messageoptions = {

                };
                $scope.items = 0;
                function refresh () {
                    cart.getCart ()
                        .success (function (data) {
                            if ( $scope.needMessage ){
                                showMessage(data);
                                $scope.needMessage  = false;
                            }
                            $scope.data = data;
                            $scope.widget.customer = data.customer;
                            $scope.widget.items_in_cart =  getItemsQuantity(data.items);

                        });
                }
                function refreshCompare() {
                    compare.getCompare ()
                        .success (function (data) {
                            $scope.comparedata = data;
                            $scope.widget.items_in_compare =  (data.items)?parseInt(data.items.length):0;

                        });

                }
                function refreshWish() {
                    wish.getList ()
                        .success (function (data) {
                            $scope.wishdata = data;
                            $scope.widget.items_in_wish =  (data.items)?parseInt(data.items.length):0;

                        });

                }
                function getItemsQuantity(items){
                    var tmpquantity = parseInt(0);
                    angular.forEach (items, function (item) {
                        tmpquantity += parseInt(item.quantity);

                    });
                    return parseInt(tmpquantity);

                }
                function showMessage(data) {
                    if(getItemsQuantity(data.items) > $scope.widget.items_in_cart ){
                        $scope.messageoptions.messageClass = "moto-store-front-messenger moto-store-front-messenger_type-success";
                    } else {
                        $scope.messageoptions.messageClass = "moto-store-front-messenger moto-store-front-messenger_type-error";
                    }
                    $scope.messageoptions.showMessage  = true;
                    setTimeout(function(){
                        $scope.messageoptions.showMessage  = false;
                    },2500);

                }
                refresh ();
                refreshCompare();
                refreshWish();
                $scope.handleToCart = function () {
                    window.location.href = $scope.data.cartPage;
                };

                $scope.handleToCompare = function () {
                    window.location.href = $scope.data.comparePage;
                };

                $scope.handleToWish = function () {
                    window.location.href = $scope.data.wishPage;
                };

                $scope.handleTargetPage = function () {

                    if ($scope.data.customer)
                    {
                        window.location.href = $scope.data.profilePage;
                    }
                    else
                    {
                        window.location.href = $scope.data.authPage;
                    }
                };

                $scope.logout = function ()
                {
                    auth.logout ().success (function () {
                        window.location.reload();
                    });
                };

                $scope.$on('store.cart.updated', function () {
                   refresh();
                    $scope.needMessage  = true;
                });
                $scope.$on('store.cart.updatedCompare', function () {
                    refreshCompare();
                });
                $scope.$on('store.cart.updatedWish', function () {
                    refreshWish();
                });
               
            }
        };
    }
]);
angular.module('StoreWebsite').directive ('storeCompareWidget', [
    'StoreWebsite.service.compare',
    'StoreWebsite.service.auth',
    function (compare, auth) {

        return {
            restrict: 'A',

            link: function ($scope, element, attributes) {

                function refreshCompare() {
                    compare.getCompare ()
                        .success (function (data) {
                            $scope.comparedata = data;
                            $scope.widget.items_in_compare =  parseInt(data.items.length);

                        });

                }
                refreshCompare();

                $scope.handleToCompare = function () {
                    window.location.href = $scope.data.comparePage;
                };

                $scope.$on('store.cart.updatedCompare', function () {
                    refreshCompare();
                });

            }
        };
    }
]);



angular.module('StoreWebsite').directive ('storeDiscount', [
    'StoreWebsite.service.cart',
    '$timeout',
    function (cart, $timeout) {

        return {
            restrict: 'A',
            scope: false,

            link: function ($scope, element, attributes) {


                $scope.discount_code_input = '';
                $scope.discount_code_input = attributes.enteredDiscount ;

                $scope.applyDiscount = function ()
                {
                    cart.applyDiscount ({discount_code: $scope.discount_code_input})
                        .success(function (data) {
                            if (data)
                            {
                                window.location.reload();
                            }
                        });
                };
            }
        };
    }
]);
angular.module('StoreWebsite').directive ('storeShipping', [
    'StoreWebsite.service.cart',
    '$timeout',
    function (cart, $timeout) {

        return {
            restrict: 'A',
            scope: false,

            link: function ($scope, element, attributes) {
                $scope.setShippingMethod = function (value)
                {
                    cart.setShippingMethod ({'id': value})
                        .success(function (data) {
                            if (data)
                            {
                                window.location.reload();
                            }
                        });
                };
            }
        };
    }
]);

angular.module('StoreWebsite').directive ('storeCountryState', [
    'StoreWebsite.service.country',
    
    function (country) {

        return {
            restrict: 'A',

            link: function ($scope, element, attributes) {
                
                var currentCountry  = attributes.currentCountry;
                var currentState    = attributes.currentState;
                var emptyCountry    = attributes.emptyCountry;
                var emptyState    = attributes.emptyState;

                $scope.states = [];

                var defaultCountry = {
                    id: 0,
                    name: emptyCountry
                };

                var defaultState = {
                    id: 0,
                    name: emptyState
                };

                $scope.country = defaultCountry;
                $scope.state = defaultState;

                function createStateList (country)
                {
                    if (country && country.states && country.states.length)
                    {
                        var values = country.states;
                        values.unshift(defaultState);
                        $scope.states = values;

                        if (currentState)
                        {
                            angular.forEach (values, function (v) {
                                if (v.id == currentState)
                                {
                                    $scope.state = v;
                                }
                            });
                        }
                    }
                    else
                    {
                        $scope.states = [];
                    }
                }

                country.getCollection ()
                    .success (function (data) {
                            var values = data.collection;

                            if (currentCountry)
                            {
                                angular.forEach (values, function (v) {

                                    if (v.id == currentCountry)
                                    {
                                        $scope.country = v;

                                        if (v.states)
                                        {
                                            createStateList (v);
                                        }
                                    }
                                });
                            }
                            values.unshift(defaultCountry);
                            $scope.countries = values;
                        }
                    );
                $scope.createStateList = createStateList;
            }
        };
    }
]);

angular.module('StoreWebsite').directive ('storeCartUnitQuantity', [
    'StoreWebsite.service.cart',

    function (cart) {

        return {
            restrict: 'A',

            link: function (scope, element, attributes) {
                element.bind('change', function() {

                    if (element.val () < 1)
                    {
                        element.val (1)
                    }

                    cart.updateItem ({product_id: attributes.productId, quantity: element.val ()})
                        .success(function () {
                            window.location.reload();
                        });
                });
            }
        }
    }
]);

angular.module('StoreWebsite').directive ('storeCartUnitRemove', [
    'StoreWebsite.service.cart',

    function (cart) {

        return {
            restrict: 'A',

            link: function (scope, element, attributes) {
                element.bind('click', function() {

                    cart.removeItem ({product_id: attributes.productId})
                        .success(function () {
                            window.location.reload();
                        });
                });
            }
        }
    }
]);
angular.module('StoreWebsite').directive ('storeCompareUnitRemove', [
    'StoreWebsite.service.compare',

    function (compare) {

        return {
            restrict: 'A',

            link: function (scope, element, attributes) {
                element.bind('click', function() {

                    compare.removeCompareItem ({product_id: attributes.productId})
                        .success(function () {
                            window.location.reload();
                        });
                });
            }
        }
    }
]);
angular.module('StoreWebsite').directive ('storeWishUnitRemove', [
    'StoreWebsite.service.wish',

    function (wish) {

        return {
            restrict: 'A',

            link: function (scope, element, attributes) {
                element.bind('click', function() {

                    wish.removeWishItem ({product_id: attributes.productId})
                        .success(function () {
                            window.location.reload();
                        });
                });
            }
        }
    }
]);