<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreCategory;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Content\Widget\AbstractWidget;
use MotoStore\Product\Entity\Category;
use MotoStore\Product\Entity\Product;

abstract class CategoryWidgetAbstract extends AbstractWidget
{
    /** @var  Category */
    public $category;
    protected $_widgetId = true;
    /**
     * @return array
     */
    public function getRenderVariables ()
    {
        $this->category = $this->getCategory ();

        return parent::getRenderVariables ();
    }

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        return '@plugins/moto-store-plugin/app/widgets/store_category/presets/'
            . $this->_name . '/'
            . $preset
            . '/template.html.twig';
    }

    /**
     * Retrieve category
     */
    public function getCategory ()
    {
        if (!$this->category)
        {
            $this->category = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Category')
                ->getCategory (Link::getEntityUri (Link::URI_SECTION_CATEGORY));

            $this->renderTextData ();
        }
        return $this->category;
    }

    /**
     * Render Linker Data
     */
    private function renderTextData ()
    {
        if ($this->category)
        {
            $renderer = clone SMStatic::getInstance()->get('store.twig');
            $renderer->setLoader (new \Twig_Loader_String ());

            $this->category->getLocaleByLanguageCode('en')
                ->setDescription (
                    $renderer->render ($this->category->getLocaleByLanguageCode('en')->getDescription ())
                );

            $this->category->getLocaleByLanguageCode('en')
                ->setShortDescription(
                    $renderer->render ($this->category->getLocaleByLanguageCode('en')->getShortDescription ())
                );
        }
    }
}