/**
 * Widget Image
 */
'use strict';

angular.module('application.widget.store.category_image', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function classWidget() {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    image: {
                        preset: 'default'
                    }


                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_category_image';
            classWidget.prototype.label = 'EDITOR.WIDGETS.CATEGORY_IMAGE.LABEL';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_category/views/image/properties.tpl.html';
            classWidget.prototype.templateUrl = function (){
                return '@plugins/moto-store-plugin/app/widgets/store_category/presets/'  + this.name + '/' + this.properties.preset + '/template.html.twig';
            };
            classWidget.prototype.allow = ['section', 'container'];
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype._dragImagePath = '@websiteWidgets/image/icons/drag.png';
            classWidget.prototype.deleteAllAlignClasses= function(){
                var self = this,
                    alignments = ['left', 'center', 'right'];

                for(var device in self.properties.align){
                    alignments.forEach(function(align){
                        if(device == 'desktop'){
                            self.$(self._dom).removeClass('moto-align-' + align );
                        }else{
                            self.$(self._dom).removeClass('moto-align-' + align + '_' + device);
                        }
                    });
                }
            };

            classWidget.prototype.setAlignObject = function(){
                var self = this;

                if (self.properties && self.properties.align && (typeof self.properties.align == 'object')) {
                    self.deleteAllAlignClasses();

                    self.$(self._dom).addClass('moto-align-' + (self.properties.align['desktop']));
                    if (self.properties.align['tablet']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['tablet']) + '_tablet');
                    if (self.properties.align['mobile-h']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-h']) + '_mobile-h');
                    if (self.properties.align['mobile-v']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-v']) + '_mobile-v');
                }
            };

            classWidget.prototype.getRenderVariables = function () {
                var self = this;

                return {
                    currentWidget: this,
                };
            };

            classWidget.prototype.update = function () {

                var self = this;

                if (self.properties.align) {
                    self.$(self._dom).removeClass('moto-align-left');
                    self.$(self._dom).removeClass('moto-align-right');
                    self.$(self._dom).removeClass('moto-align-center');

                    self.$(self._dom).attr('data-align', JSON.stringify(self.properties.align));
                }

                self.setAlignObject();
                AbstractWidgetClass.prototype.update.call(this);
            };

            classWidget.prototype.initialize = function () {
                var self = this;

                var propertiesNode = self.$('script[type="text/widget-properties"]', self._dom);

                if (propertiesNode.length) {
                    var properties;

                    try {
                        properties = angular.fromJson(propertiesNode.text().trim());
                    } catch (ignored) {
                    }

                    if (angular.isObject(properties)) {
                        jQuery.extend(true, self.properties, properties);
                    }

                }

                if(typeof self.properties.align == 'string') {
                    self.properties.align = {
                        "desktop": self.properties.align,
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    };
                }

                try{
                    self.properties.align = JSON.parse(self.$(self._dom).data('align'));
                }catch (ev){
                    self.properties.align = self.$(self._dom).data('align') || self.properties.align;
                }


                self.setAlignObject();

                AbstractWidgetClass.prototype.initialize.call(this);
            };



            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: 'store_category_image',
                label: 'EDITOR.WIDGETS.CATEGORY_IMAGE.LABEL',
                category: "store",
                order: 22,
                enabled: true,
                allowed: function (page, sectionName) {
                    return "template.store.category" == page.type &&  sectionName == "content";
                },
                icons: {
                    small: 'icon icon-image',
                    medium: 'icon icon-image',
                    large: 'icon icon-image'
                }
            });

        }
    ]);