<?php
namespace Website\Widgets\StoreCategoryTree;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use Website\Widgets\StoreCategory\CategoryWidgetAbstract;

class Widget extends CategoryWidgetAbstract
{
    public $categories = array();
    /**
     * @var string
     */
    protected $_name = 'store_category_tree';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset'=> 'default',
        'item_text_style'=> 'default',
        'align'=> array(
        "desktop"=> 'left',
        "tablet"=> '',
        "mobile-h"=> '',
        "mobile-v"=> ''
        ),
        'spacing'=> array(
            'top'=> 'auto',
            'right' => 'auto',
            'bottom' => 'auto',
            'left' => 'auto'
        ),
        'expanded'=> 0
    );

    public function getRenderVariables()
    {
        $this->categories = $this->getCategoriesTree ($this->isCustomerBtob());
        return array(
            'widget' => $this,
            'currentWidget' => $this,
            'categories' => $this->categories,
            'current' => $this->presentActiveCategory (),
            'isExpanded' => ($this->preset == 4 || $this->preset == 5) && $this->expanded ? 1 : 0,
        );
    }

    /**
     * @return array
     */
    private function presentActiveCategory ()
    {
        $presented = array ();

        if ($this->getCategory ())
        {
            $list = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Category')
                ->getBreadcrumbs ($this->getCategory ());


            $presented = array_keys ($list);
        }

        return $presented;
    }

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . ($this->preset ? $this->preset : $preset) . '/template.html.twig';

        return $template;
    }

    /**
     * Retrieve categories tree
     */
    public function getCategoriesTree ($show_btob)
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Category')
            ->getTree ($show_btob);
    }

    protected  function isCustomerBtob()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();
        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                return (bool)$customer->getBtob ();
            }
        }
        return false;

    }
}