'use strict';

angular.module('application.widget.store.category_tree', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function Controller($scope, CategoryService)
            {
                var widget = $scope.currentWidget;

                widget.isExpanded = $scope.currentWidget.properties.preset == 4 && $scope.currentWidget.properties.expanded ? 1 : 0;
                $scope.$on('widgetPropertiesChanged', function () {
                    widget.isExpanded = $scope.currentWidget.properties.preset == 4 && $scope.currentWidget.properties.expanded ? 1 : 0;
                });

                CategoryService.getTree ()
                    .success (function (tree) {
                        widget.categories = tree;
                        widget.renderPreview();
                    });
            }

            Controller.$inject = ['$scope', 'store.category.services.CategoryService'];

            function classWidget() {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    expanded: 0
                };

                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.controller = Controller;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.name = 'store_category_tree';
            classWidget.prototype.label = 'EDITOR.WIDGETS.CATEGORY_TREE.LABEL';
            classWidget.prototype.categories = [];
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_category_tree/views/properties.tpl.html';
            classWidget.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_category_tree/icons/drag-store-categories.png';
            classWidget.prototype.templateUrl = function (){
                return '@plugins/moto-store-plugin/app/widgets/' + this.name + '/presets/' + this.properties.preset + '/template.html.twig';
             };
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype.deleteAllAlignClasses= function(){
                var self = this,
                    alignments = ['left', 'center', 'right'];

                for(var device in self.properties.align){
                    alignments.forEach(function(align){
                        if(device == 'desktop'){
                            self.$(self._dom).removeClass('moto-align-' + align );
                        }else{
                            self.$(self._dom).removeClass('moto-align-' + align + '_' + device);
                        }
                    });
                }
            };

            classWidget.prototype.renderCategoriesTree = function (element) {

                var categoryHelper = new StoreCategoryHelper (element);
                categoryHelper.render();

            };

            classWidget.prototype.setAlignObject = function(){
                var self = this;

                if (self.properties && self.properties.align && (typeof self.properties.align == 'object')) {
                    self.deleteAllAlignClasses();

                    self.$(self._dom).addClass('moto-align-' + (self.properties.align['desktop']));
                    if (self.properties.align['tablet']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['tablet']) + '_tablet');
                    if (self.properties.align['mobile-h']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-h']) + '_mobile-h');
                    if (self.properties.align['mobile-v']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-v']) + '_mobile-v');
                }
            };

            classWidget.prototype.getRenderVariables = function () {
                var self = this;

                return {
                    current : [],
                    widget: self.properties,
                    categories: self.categories,
                    isExpanded: self.isExpanded,
                    currentWidget: this
                };
            };


            classWidget.prototype.update = function () {

                var self = this;

                if (self.properties.align) {
                    self.$(self._dom).removeClass('moto-align-left');
                    self.$(self._dom).removeClass('moto-align-right');
                    self.$(self._dom).removeClass('moto-align-center');

                    self.$(self._dom).attr('data-align', JSON.stringify(self.properties.align));
                }

                self.renderCategoriesTree(self.$(self._dom).find ('.moto-widget-store-sidebar_nav'));

                self.setAlignObject();
                AbstractWidgetClass.prototype.update.call(this);
            };

            classWidget.prototype.initialize = function () {
                var self = this;



                if(typeof self.properties.align == 'string') {
                    self.properties.align = {
                        "desktop": self.properties.align,
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    };
                }

                try{
                    self.properties.align = JSON.parse(self.$(self._dom).data('align'));
                }catch (ev){
                    self.properties.align = self.$(self._dom).data('align') || self.properties.align;
                }


                self.setAlignObject();

                AbstractWidgetClass.prototype.initialize.call(this);
            };

            classWidget.prototype.isCopyable = function() {
                return true;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };
            classWidget.prototype.$onInit = function () {
                var self = this;
               self.controller.getTree();
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: 'store_category_tree',
                label: 'EDITOR.WIDGETS.CATEGORY_TREE.LABEL',
                category: "store",
                order: 22,
                enabled: true,
                allowed: function (page, sectionName) {
                    return [
                            "template.store.home",
                            "template.store.product",
                            "template.store.category"
                        ].indexOf(page.type) !== -1 &&  sectionName == "content";

                },
                icons: {
                    small: 'icon icon-store-category',
                    medium: '',
                    large: 'icon icon-store-category'
                }
            });
        }
]);
