<?php
namespace Website\Widgets\StoreCheckout;

use Moto;
use MotoStore\Content\Controller\CheckoutController;
use MotoStore\Content\Helper\Link;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_checkout';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'spacing'=> array(
            'top'=> 'auto',
            'right' => 'auto',
            'bottom' => 'auto',
            'left' => 'auto'
        )
    );

    public function getRenderVariables()
    {
        $uri = Link::getEntityUri (Link::URI_SECTION_CHECKOUT);
        $controller = new CheckoutController ();

        return array (
            'widget' => $this,
            'currentWidget' => $this,
            'checkoutPageContent' => $controller->checkout ($uri, $this)
        );

    }


    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}