<?php
namespace Website\Widgets\StoreCompare;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Controller\AccountController;
use MotoStore\Content\Controller\CompareController;
use MotoStore\Settings\Entity\Option;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_compare';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'thumbnail' => array(
            'hide' => false,
            'preset' => 'moto-preset-4'
        ),
        'product_title_style' => 'moto-text_normal',
        'product_price_style' => 'moto-text_system_7',
        'properties_values_style' => 'moto-text_system_11',
        'page_heading' => 'moto-text_system_6',
        'properties_heading_style' => 'moto-text_normal',
        'tip_style' => 'moto-text_system_10',
        'labelColor' => array(
            'background' => null
        ),
        'labelHexColor' => null,
        'wrapWord' =>  true,
        'button' => array(
            'active' => true,
            'size' => 'medium',
            'preset' => 'moto-preset-2',
            'text' => 'Add to cart'
        ),
        'button_back' => array(
            'size' => 'medium',
            'preset' => 'moto-preset-4',
        ),
        'auto_redirect' => true,
    );

    public function getRenderVariables()
    {
        $controller = new CompareController ();
        if($this->isCatalogModeEnabled()){
            $this->properties['hide_prices'] = true;
        }
        return array (
            'currentWidget' => $this,
            'comparePageContent' => $controller->compare ($this)
        );

    }
    public function isCatalogModeEnabled(){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $catalog_mode = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode');
        return !!$catalog_mode;
    }

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}