<?php
namespace Website\Widgets\StoreFilters;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Order\Cart\Storage;
use Website\Widgets\StoreCategory\CategoryWidgetAbstract;
use Zend\Http\PhpEnvironment\Request;

class Widget extends CategoryWidgetAbstract
{

    protected $_name = 'store_filters';
    protected $_defaultOptions = array(
        'preset'=> 'default',
        'align'=> array(
        "desktop"=> 'left',
        "tablet"=> '',
        "mobile-h"=> '',
        "mobile-v"=> ''
        ),
        'spacing'=> array(
            'top'=> 'auto',
            'right' => 'auto',
            'bottom' => 'auto',
            'left' => 'auto'
        ),
        'expanded'=> 0
    );

    public $category;
    public $filter_brands;
    public $filter_proprties;
    public $request;
    protected $_widgetId = true;

    public function __construct ($options = array())
    {
        $this->request = new Request ();
        parent::__construct ($options);
    }

    /**
     * @return array
     */
    public function getRenderVariables ()
    {
        $hide = false;
        $this->category = $this->getCategory ();
        if ($this->category == null){
            $hide = true;
        }
        $this->filterListener ();
        $storage = new Storage();
        $cat_id = null;
        if ($this->category){
            $cat_id =  $this->category->getId();
            foreach ($this->category->getBrands() as $key=>$brand ){
                $tmpbrand = $brand->getBrand();
                if($tmpbrand){
                    try{
                        if ($tmpbrand->getName()){
                            $this->filter_brands[] = $tmpbrand;
                        }
                    }
                    catch (\Exception $e){

                    }
                }
            };
            foreach ($this->category->getProperties() as $key=>$property ){
                $tmpproperty = $property->getProperty();
                if($tmpproperty){
                    try{
                        if ($tmpproperty->getName()){
                            $this->filter_proprties[] = $tmpproperty;
                        }
                    }
                    catch (\Exception $e){

                    }
                }
            };
        }




        return array(
            'widget' => $this,
            'currentWidget' => $this,
            'category' => $this->category,
            'filter_brands' => $this->filter_brands,
            'filter_proprties' => $this->filter_proprties,
            'filters' => $storage->getFilters($cat_id),
            'properties' => $this->getProperties($this->category),
            'hide' => $hide
        );
    }



    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/default/template.html.twig';

        return $template;
    }

    protected function filterListener ()
    {

        if ($this->category)
        {
            $storage = new Storage ();

            $cat_id = $this->category->getId ();
            $filters = $this->request->getQuery ('filters', null);
            if ($filters){
                $storage->setFilters($filters, $cat_id);
            }

        }

        return true;

    }

}