/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

'use strict';

angular.module('application.widget.store.store_forgot', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function classWidget() {
                this.properties = {
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    }
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_forgot';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_FORGOT.NAME';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_forgot/views/properties.tpl.html';
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_forgot/presets/default/template.front.twig'
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };
            /**
             * Initialize Widget
             */
            classWidget.prototype.initialize = function() {
                var self = this;

                AbstractWidgetClass.prototype.initialize.call(self);
            };
            classWidget.prototype.isCopyable = function() {
                return false;
            };
            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };
            WidgetFactory.set('store_forgot', classWidget);

            WidgetsService.addWidget({
                name: 'store_forgot',
                label: 'EDITOR.WIDGETS.STORE_FORGOT.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.forgot" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
    ]);
