<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreProduct;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Content\Widget\AbstractWidget;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Option;

abstract class ProductWidgetAbstract extends AbstractWidget
{
    /** @var  Product */
    public $product;
    protected $_widgetId = true;
    public $productSetting  = array ();

    /**
     * @return array
     */
    public function getRenderVariables ()
    {

        $this->product = $this->getProduct ();
        $this->productImages = $this->getProductImages ();
        $this->productSetting = $this->getOptionsRepository ()->getModuleOptions (Option::OPTION_STORE_SETTINGS_PRODUCT);
        $this->currency =  $this->getCurrencyList();
        return array_merge(array (
            'productImages' => $this->productImages
        ), parent::getRenderVariables());
    }

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/store_product/presets/'  . $this->_name . '/' . $preset . '/template.html.twig';
        return $template;
    }

    /**
     * Retrieve categories tree
     */
    public function getProduct ()
    {
        if (!$this->product)
        {
            $this->product = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->getProduct (Link::getEntityUri (Link::URI_SECTION_PRODUCT));

            $this->renderTextData ();
        }
        $customerDiscount = $this->getCustomerDiscount();
        if( $this->product && $customerDiscount){
            $tmpPrice = $this->product->getPrice();
            $this->product->setHasSpecialPrice(true);
            $this->product->setSpecialDateStart(new \DateTime('-1 day'));
            $this->product->setSpecialDateEnd(new \DateTime('+1 day'));
            $this->product->setSpecialPrice($tmpPrice - $tmpPrice*$customerDiscount/100);

        }



        return $this->product;
    }
    private  function  getProductImages ()
    {

        $product_images = array();

        if ($this->product)
        {
            $images = $this->product->getImages();

            foreach ( $images as $key=>$image){
                $metiaItem =  SMStatic::getInstance ()
                    ->get ('MotoStore\EntityManager')
                    ->getRepository ('MotoStore\Platform\Entity\Media')
                    ->find (array ('id' => $image->getMediaId()));

                $product_images[$key] = [];
                $product_images[$key]['id'] = $image->getMediaId();
                $product_images[$key]['alt'] = $metiaItem->getAlt();
                $product_images[$key]['path'] = $metiaItem->getPath();
                $product_images[$key]['title'] = $metiaItem->getTitle();
            }
        }

        return $product_images;
    }
    private  function getCustomerDiscount()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();

        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                $discount = $customer->getLoyaltyDiscount();
                if($discount && $discount > 0 && $discount < 100){
                    return $discount;
                } else {
                    return false;
                }
            }
        }
        return false;

    }

    private function renderTextData ()
    {
        if ($this->product)
        {
            $this->product->getLocaleByLanguageCode('en')
                ->setDescription ($this->product->getLocaleByLanguageCode('en')->getDescription ());
            $this->product->getLocaleByLanguageCode('en')
                ->setShortDescription($this->product->getLocaleByLanguageCode('en')->getShortDescription ());
        }
    }
    protected function getCurrencyList ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getActiveCurrenciesList ();
    }
}