<?php
namespace Website\Widgets\StoreProductAddToWishlist;

use Moto;
use MotoStore\Product\Entity\Product;
use Website\Widgets\StoreProduct\ProductWidgetAbstract;
use MotoStore\Content\Content\DI\SMStatic;

class Widget extends ProductWidgetAbstract
{
    /**
     * @var string
     */
    protected $_name = 'store_product_add_to_wishlist';
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'button' => array(
            'preset' => 'default',
            'text' => 'Compare',
            'size' => 'large'
        ),
        'auto_redirect' => false,
    );
    protected $_widgetId = true;

    /** @var  Product */
    public $product;

    /**
     * @return array
     */
    public function getRenderVariables ()
    {

        $this->product = parent::getProduct ();
        return array_merge(
            array (
                'is_product_in_wishlist' => $this->getIfProductInWishList (),
                'is_customer_logged_in' => $this->getIfCustomerLoggedIn ()
            ), parent::getRenderVariables());
    }

    private  function getIfProductInWishList()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();

        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer && $this->product){

                $product_id = $this->product->getId();
                $wishlist_json = $customer->getWishList();
                $wishlist_array = array();
                if ($wishlist_json !== null){
                    $wishlist_array = json_decode($wishlist_json,true);
                }
                if (isset($wishlist_array[$product_id])){
                   return true;
                }
                return false;
            }
        }
        return false;

    }

    private  function getIfCustomerLoggedIn()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();

        if($identity)
        {
            return true;
        }
        return false;

    }
}