<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreProductRelatedProducts;

use Moto;
use MotoStore\Product\Entity\Product;
use Website\Widgets\StoreProduct\ProductWidgetAbstract;
use MotoStore\Collection\Collection;
use MotoStore\Content\Helper\Link;
use MotoStore\Collection\Query\Param;
use MotoStore\Settings\Entity\Currency;
use MotoStore\Settings\Entity\Option;
use MotoStore\Content\Content\DI\SMStatic;

class Widget extends ProductWidgetAbstract
{

    /** @var  Product */
    protected $_name = 'store_product_related_products';
    protected $_defaultOptions = array(
        'preset' => 'default',
        'row_size' => 4,
        'per_page' => 4,
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'placeholder' => 'Product Title'
    );


    public function __construct ($options = array())
    {
        parent::__construct ($options);
        $this->product = $this->getProduct();
        $this->related = $this->product->getRelated();
        if (!Moto\Website\Application::getInstance()->isPreviewMode()) {
            $this->getRelatedProductsCollection($this->_options ['per_page']);
        } else {
            $this->getDummyRelatedProductsCollection($this->_options ['per_page']);
        }


    }
    public function getRenderVariables()
    {
        if($this->isCatalogModeEnabled()){
            $this->properties['hide_prices'] = true;
        }
        return array_merge(array (
            'currency' => $this->getDisplayCurrency (),
            'related_products' => $this->related_products
        ), parent::getRenderVariables());
    }
    public function isCatalogModeEnabled(){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $catalog_mode = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode');
        return !!$catalog_mode;
    }

    public function getProduct ()
    {
        $expr = array ();

        if ($l = Link::getEntityUri (Link::URI_SECTION_PRODUCT))
        {
            $expr ['uri'] = $l;
        }

        $product = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->findOneBy ($expr);

        return $product;
    }

    /**
     * @return mixed
     */
    protected function getRelatedProductsCollection ($amount)
    {

        if (!$this->related || count($this->related) < 1)
        {

            $collection = SMStatic::getInstance ()
                ->get ('store.collection.product_list');
            $collection
                ->setFilters ($this->createFilterParams ())
                ->setLimit($amount);

                $collection
                    ->getQuery ()
                    ->orderBy ('p.created_date', 'DESC');



            $result = $collection
                ->getCollectionWithMetaData ();

            $this->related_products = $result ['collection'];
            $this->countproducts = count ($this->related_products);

        }
        else {
            $keys = array();
            foreach ($this->related as $item){
                $keys[] = $item->getProductId();
            }
            $filters = array (
                new Param ('visibility', Param::OPERATOR_EQ, Product::PRODUCT_VISIBLE),
            );

            $filters [] = new Param ('id', Param::OPERATOR_IN, $keys);
            $collection = SMStatic::getInstance ()
                ->get ('store.collection.product_list');
            $collection
                ->setFilters ($filters)
                ->setLimit($amount);

            $collection
                ->getQuery ()
                ->orderBy ('p.created_date', 'DESC');



            $result = $collection
                ->getCollectionWithMetaData ();

            $this->related_products = $result ['collection'];
            $this->countproducts = count ($this->related_products);
        }
        return $this->related_products;
    }

    public function getDummyRelatedProductsCollection ($amount){
        $collection = SMStatic::getInstance ()
            ->get ('store.collection.product_list')
            ->setLimit($amount);
        $result = $collection
            ->getCollectionWithMetaData ();
        $this->related_products = $result ['collection'];

        return $this->related_products;

    }



    protected function createFilterParams ()
    {

        $filters = array (
            new Param ('visibility', Param::OPERATOR_EQ, Product::PRODUCT_VISIBLE),
        );

        $filters [] = new Param ('id', Param::OPERATOR_NOT_EQ, $this->product->getId());
        $category = $this->product->getCategories()->first ();
        if ($category)
        {
            $catid = $category->getId();
            $filters [] = new Param ('category_id', Param::OPERATOR_EQ, $catid);
        }

        if (!$this->getOptionsRepository ()->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'display_out_stock_product', 0))
        {
            $filters [] = new Param ('quantity', Param::OPERATOR_GREATER, 0);
        }
        return $filters;
    }



    protected function getDisplayCurrency ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getDisplayCurrency ();
    }


    protected  function isCustomerBtob()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();
        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                return (bool)$customer->getBtob ();
            }
        }
        return false;

    }



    protected function getCategory ($uri)
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Category')
            ->getCategory ($uri);
    }


}