<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreProductTax;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Currency;
use Website\Widgets\StoreProduct\ProductWidgetAbstract;
use MotoStore\Settings\Entity\Option;

class Widget extends ProductWidgetAbstract
{
    /**
     * @var string
     */
    protected $_name = 'store_product_tax';

    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'show_prices' => true,
        'show' => false,
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'placeholder' => array(
                        'tax' => '9.99'
        ),
        'style' => 'moto-text_system_7'
    );
    public function getRenderVariables()
    {
        $variables = parent::getRenderVariables();
        if ($this->product && $this->isUseSimplifiedTax()) {
            $this->properties['show'] = true;

                if ($this->isPriceIncludeTax()) {
                    $this->properties['tax'] = $this->product->getFinalPrice() / (1 + $this->getSimplifiedTaxRate () / 100) * ($this->getSimplifiedTaxRate () / 100);
                } else {
                    $this->properties['tax'] = $this->product->getFinalPrice() * ($this->getSimplifiedTaxRate () / 100);
                }

        }

        if($this->isCatalogModeEnabled()){
            $this->properties['show_prices'] = false;
        }
        return array_merge(array ('currency' => $this->getDisplayCurrency ()), parent::getRenderVariables());
    }

    protected function isPriceIncludeTax ()
    {
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'display_price_inc_tax');
    }

    protected function isUseSimplifiedTax ()
    {
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'use_simplified_taxes');
    }


    protected function getSimplifiedTaxRate ()
    {
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'simplified_tax_rate');
    }

    public function isCatalogModeEnabled(){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $catalog_mode = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode');
        return !!$catalog_mode;
    }

    /**
     * @return Currency
     */
    protected function getDisplayCurrency ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getDisplayCurrency ();
    }
}