<?php

namespace Website\Widgets\StoreProductVideo;

use Moto;
use MotoStore\Product\Entity\Product;
use Website\Widgets\StoreProduct\ProductWidgetAbstract;
use MotoStore\Collection\Collection;
use MotoStore\Content\Helper\Link;
use MotoStore\Collection\Query\Param;
use MotoStore\Settings\Entity\Currency;
use MotoStore\Settings\Entity\Option;
use MotoStore\Content\Content\DI\SMStatic;


class Widget extends ProductWidgetAbstract
{
    /**
     * @var string
     */
    protected $_name = 'store_product_video';
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        )
    );
    public function __construct ($options = array())
    {
        parent::__construct ($options);
        $this->product = $this->getProduct();


    }

    public function getRenderVariables()
    {
        return array_merge(array ('video_uri' => $this->product->getVideoUri()), parent::getRenderVariables());
    }


    public function getProduct ()
    {
        $expr = array ();

        if ($l = Link::getEntityUri (Link::URI_SECTION_PRODUCT))
        {
            $expr ['uri'] = $l;
        }

        $product = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->findOneBy ($expr);

        return $product;
    }
}