<?php
namespace Website\Widgets\StoreProduct;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Content\Widget\AbstractWidget;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Currency;
use MotoStore\Settings\Entity\Option;


/**
 * @deprecated
 * @todo pls remove this class
 * Class Widget
 * @package Website\Widgets\StoreProduct
 */
class Widget extends AbstractWidget
{
    /** @var  Product */
    protected $product;
    /**
     * @var array
     */
    public $reviews= array();
    /**
     * @var string
     */
    protected $_name = 'store_product';
    protected $_widgetId = true;
  
    /**
     * @return array
     */
    public function getRenderVariables()
    {
        $this->product = $this->getProduct ();
        $this->reviews = $this->presentReviews ();

        return array (
            'widget'    => $this,
            'currentWidget'    => $this,
            'product'   => $this->product,
            'currency'  => $this->getDisplayCurrency (),
        );
    }

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }

    /**
     * Retrieve categories tree
     */
    public function getProduct ()
    {
        $expr = array ();

        if ($l = Link::getEntityUri (Link::URI_SECTION_PRODUCT))
        {
            $expr ['uri'] = $l;
        }

        $product = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->findOneBy ($expr);

        return $product;
    }

    /**
     * @return Currency
     */
    protected function getDisplayCurrency ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getDisplayCurrency ();
    }


    /**
     * Reviews
     * @return array
     */
    protected function presentReviews ()
    {
        return array (
            'isActive'  => $this->getOptionsRepository ()->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'enabled_reviews'),
            'token'     => $this->getOptionsRepository ()->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'yotpo_token'),
        );
    }
}