/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

angular.module('StoreWebsite.widget.store_product', ['core.library.jsonrpc', 'ngFileUpload']);

angular.module('StoreWebsite.widget.store_product').service ('StoreWebsite.service.product', [
    'jsonrpc',

    function (jsonrpc) {
        var service         = jsonrpc.newService('store_product_service');
        this.getVariants    = service.createMethod('getVariants');
        this.getOptions     = service.createMethod('getOptions');
        this.getCustomOptions     = service.createMethod('getCustomOptions');
        this.getCurrency    = service.createMethod('getCurrency');
        this.getApiPath = jsonrpc.getBasePath;
    }
]);


/**
 * Service Provide product frontend logic
 */
angular.module('StoreWebsite.widget.store_product').service ('StoreWebsite.service.productLogic', [
    '$rootScope',

    function ($rootScope) {

        var quantity = 1,
            variant  = {},
            custom_options = {},
            tierPrices = [],
            currency = {},
            variants = {};


        /**
         * Change Product Quantity
         * @param q
         */
        this.setQuantity  = function (q) {
            quantity = q;
        };

        /**
         * Return Product Quantity
         * @returns {number}
         */
        this.getQuantity = function () {
            return quantity;
        };

        this.setTierPricesSettings = function (tp) {
            return tierPrices = tp;
        };

        this.getTierPrice = function () {

            var matchedQuantity = 0,
                matchedPrice = 0;

            if (tierPrices.length)
            {
                tierPrices.map(function (tp) {
                    if (tp.q <= quantity && matchedQuantity < tp.q)
                    {
                        matchedQuantity = tp.q;
                        matchedPrice = tp.p;
                    }
                })
            }
            return matchedPrice;
        };



        /**
         * Set Product Variant
         * @param v
         */
        this.setVariant = function (v) {
            variant = v;
            $rootScope.$broadcast("store.variant.changed");
        };

        this.getVariant = function () {
            return variant;
        };
        /**
         * Set Product Variants
         * @param v
         */
        this.setVariants = function (v) {
            variants = v;
        };

        this.getVariants = function () {
            return variants;
        };

        /**
         * Set Product Custom Options
         * @param options
         */
        this.setCustomOptions = function (options) {
            custom_options = options;
            $rootScope.$broadcast("store.custom_options.changed");
        };

        this.broadcastPriceUpdate = function () {
            $rootScope.$broadcast("store.custom_options.changed");
        };


        this.getCustomOptions = function () {
            return custom_options;
        };

        /**
         * Set Product Currency Token
         * @param cur
         */
        this.setCurrency = function (cur) {
            currency = cur;
        };

        this.getCurrency = function () {
            return currency;
        };

        this.number_format = function( number, decimals, dec_point, thousands_sep ) {
            var i, j, kw, kd, km;
            if( isNaN(decimals = Math.abs(decimals)) ){
                decimals = 2;
            }
            if( dec_point == undefined ){
                dec_point = ",";
            }
            if( thousands_sep == undefined ){
                thousands_sep = ".";
            }
            i = parseInt(number = (+number || 0).toFixed(decimals)) + "";
            if( (j = i.length) > 3 ){
                j = j % 3;
            } else{
                j = 0;
            }
            km = (j ? i.substr(0, j) + thousands_sep : "");
            kw = i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands_sep);
            kd = (decimals ? dec_point + Math.abs(number - i).toFixed(decimals).replace(/-/, 0).slice(2) : "");
            return km + kw + kd;
        }

    }
]);

/**
 * Product Quantity Control
 */
angular.module('StoreWebsite.widget.store_product').directive ('storeProductQuantity', [
    'StoreWebsite.service.productLogic',
    function (productLogic) {
        return {
            link: function ($scope, element, attr) {
                var $element = $(element),
                    available_quantity    = $element.parent().find('.moto-widget-available-quantity');

                $scope.quantity = 1;

                $scope.$on('store.variant.changed', function () {
                    var v = productLogic.getVariant(),
                        variants = productLogic.getVariants();
                    if (variants.length < 1 ){
                        $('.moto-widget-store-product-add-to-cart').show();
                        return;
                    }
                    if (!Object.keys(v).length )
                    {
                        available_quantity.text(0);
                        $('.moto-widget-store-product-add-to-cart').hide();
                        return;
                    }
                    if (v.quantity)
                    {
                        available_quantity.text(v.quantity);
                    } else {
                        available_quantity.text(0);
                    }
                    $('.moto-widget-store-product-add-to-cart').show();
                    return;

                });

                productLogic.setTierPricesSettings (angular.fromJson (attr.tierPrices));
                $scope.updateQuantity = function () {
                    if ($scope.quantity) {
                        productLogic.setQuantity($scope.quantity);


                        var price    = $('.moto-widget-store-main_item-price').children().first(),
                            old_price = $('.moto-widget-store-main_item-old_price').children().first();

                            if (productLogic.getTierPrice())
                            {
                                price.text(productLogic.getTierPrice());
                            }
                    }
                }
            }
        }
    }
]);


/**
 * Product Price
 */
angular.module('StoreWebsite.widget.store_product').directive ('storeProductPrice', [
    'StoreWebsite.service.product',
    'StoreWebsite.service.productLogic',
    function (product, productLogic) {
        return {
            link: function ($scope, element) {
                var $element = $(element),
                    price    = $element.find('.moto-widget-store-main_item-price').children().first(),
                    old_price = $element.find('.moto-widget-store-main_item-old_price').children().first();

                $scope.$on('store.variant.changed', function () {
                    var tmpprice = $element.attr('data-price-origin'),
                        numberformatted,pricetextformatted;
                    if (productLogic.getTierPrice())
                    {
                        price.text(productLogic.getTierPrice());
                    }
                    var curr = productLogic.getCurrency();
                    tmpprice = parseFloat(tmpprice.replace(curr.token,''));
                    var co = productLogic.getCustomOptions();

                    var v = productLogic.getVariant();
                    if (!Object.keys(v).length)
                    {
                        return;
                    }

                    if (v.final_price)
                    {
                        tmpprice = v.price;
                        angular.forEach(co, function(option) {
                            if (option.value && option.value != ''){
                                tmpprice = tmpprice + parseFloat(option.price);
                            }

                        });
                        if (v.price > $element.attr('data-price'))
                        {
                            old_price.hide();
                        }
                        else
                        {
                            old_price.show();
                        }
                    }
                    else
                    {
                        angular.forEach(co, function(option) {
                            if (option.value && option.value != ''){
                                tmpprice = tmpprice + parseFloat(option.price);
                            }

                        });
                    }
                    tmpprice = tmpprice*parseFloat(curr.exchangeRate);
                    numberformatted = productLogic.number_format (
                        tmpprice, curr.decimalPlaces, curr.decimalPoint, curr.thousandsSeparator
                    );

                    var spacing = '';
                    if (curr.spacer){
                        spacing = ' ';
                    }

                    pricetextformatted = (curr.location=='left')
                        ? curr.token + spacing + numberformatted
                        : numberformatted + spacing + curr.token;
                    price.text(pricetextformatted);

                });
                $scope.$on('store.custom_options.changed', function () {
                    var tmpprice, numberformatted, pricetextformatted;
                    if (productLogic.getTierPrice()) {
                        tmpprice = productLogic.getTierPrice();
                        price.text(tmpprice);

                    } else {
                       tmpprice = $element.attr('data-price');
                    }
                    var curr = productLogic.getCurrency();
                    tmpprice = parseFloat(tmpprice.replace(curr.token,''));
                    var co = productLogic.getCustomOptions();

                    if (Object.keys(co).length) {
                        var v = productLogic.getVariant();
                        if (Object.keys(v).length) {
                            if (v.price) {
                                tmpprice = v.price;
                                angular.forEach(co, function(option) {
                                    if (option.value && option.value != ''){
                                        tmpprice = tmpprice + parseFloat(option.price);
                                    }

                                });
                                if (tmpprice > $element.attr('data-price')) {
                                    old_price.hide();
                                }
                                else {
                                    old_price.show();
                                }
                            }
                        } else {
                            angular.forEach(co, function(option) {
                                if (option.value && option.value != ''){
                                    tmpprice = tmpprice + parseFloat(option.price);
                                }

                            });
                        }
                    }
                    tmpprice = tmpprice*parseFloat(curr.exchangeRate);
                    numberformatted = productLogic.number_format (
                        tmpprice, curr.decimalPlaces, curr.decimalPoint, curr.thousandsSeparator
                    );


                    var spacing = '';
                    if (curr.spacer){
                        spacing = ' ';
                    }

                    pricetextformatted = (curr.location=='left')
                        ? curr.token + spacing + numberformatted
                        : numberformatted + spacing + curr.token;
                    price.text(pricetextformatted);


                  price.text(pricetextformatted);






                });
            }
        }
    }
]);


/**
 * Product Media
 */
angular.module('StoreWebsite.widget.store_product').directive ('storeProductCarousel', [
    'StoreWebsite.service.productLogic',
    function (productLogic) {
        return {
            link: function ($scope, element) {
                var $element        = $(element),
                    carouselStage   = $element.find('.carousel-stage').jcarousel(),
                    carouselNavigation   = $element.find('.carousel-navigation').jcarousel(),
                    prev   = $element.find('.prev-stage'),
                    next   = $element.find('.next-stage'),
                    prevNav   = $element.find('.prev-navigation'),
                    nextNav   = $element.find('.next-navigation'),
                    imageIdIndexMap = {};

                var connector = function(itemNavigation, carouselStage) {

                    var index = itemNavigation.index();

                    imageIdIndexMap[itemNavigation.attr('data-image-id')] = index;
                    return carouselStage.jcarousel('items').eq(index);
                };

                carouselNavigation.jcarousel('items').each(function() {
                    var item = $(this);

                    var target = connector(item, carouselStage);

                    item
                        .on('jcarouselcontrol:active', function() {
                            item.addClass('active');
                        })
                        .on('jcarouselcontrol:inactive', function() {
                            item.removeClass('active');
                        })
                        .jcarouselControl({
                            target: target,
                            carousel: carouselStage
                        });
                });

                prev
                    .on('jcarouselcontrol:inactive', function() {
                        $(this).addClass('inactive');
                    })
                    .on('jcarouselcontrol:active', function() {
                        $(this).removeClass('inactive');
                    })
                    .jcarouselControl({
                        target: '-=1'
                    });

                next
                    .on('jcarouselcontrol:inactive', function() {
                        $(this).addClass('inactive');
                    })
                    .on('jcarouselcontrol:active', function() {
                        $(this).removeClass('inactive');
                    })
                    .jcarouselControl({
                        target: '+=1'
                    });

                // Setup controls for the navigation carousel
                prevNav
                    .on('jcarouselcontrol:inactive', function() {
                        $(this).addClass('inactive');
                    })
                    .on('jcarouselcontrol:active', function() {
                        $(this).removeClass('inactive');
                    })
                    .jcarouselControl({
                        target: '-=1'
                    });

                nextNav
                    .on('jcarouselcontrol:inactive', function() {
                        $(this).addClass('inactive');
                    })
                    .on('jcarouselcontrol:active', function() {
                        $(this).removeClass('inactive');
                    })
                    .jcarouselControl({
                        target: '+=1'
                    });

                $scope.$on('store.variant.changed', function () {

                    var v = productLogic.getVariant();

                    if (v.image && v.image.id)
                    {
                        carouselStage.jcarousel('scroll', imageIdIndexMap[v.image.id]);
                    }
                });
            }
        }
    }
]);

/**
 * Product Add to Cart Button Action
 */
angular.module('StoreWebsite.widget.store_product').directive ('storeProductAddToCart', [
    'StoreWebsite.service.productLogic',
    'StoreWebsite.service.cart',
    '$window',
    '$rootScope',
    function (productLogic, cart, $window, $rootScope) {
        return {
            restrict: 'A',
            link: function ($scope, element, attributes) {

                element.bind('click', function () {
                    var variant = productLogic.getVariant();
                    var custom_options = productLogic.getCustomOptions();
                    if (attributes.mainproductId)
                    {
                        variant = 0;
                        custom_options = '';
                    }
                    var itemdata = {
                        product_id: attributes.productId,
                        quantity: productLogic.getQuantity (),
                        variant_id: variant.id ? variant.id : 0,
                        custom_options : custom_options ?  custom_options : '',
                    };
                    cart.addItem(itemdata)
                        .success(function (data) {
                        if (attributes.autoredirect)
                        {
                            $window.location = attributes.location;
                        }
                        else
                        {
                            $rootScope.$broadcast('store.cart.updated');
                        }
                    });
                });
            }
        }
    }
]);
/**
 * Product Add to Compare List Button Action
 */
angular.module('StoreWebsite.widget.store_product').directive ('storeProductAddToCompare', [
    'StoreWebsite.service.productLogic',
    'StoreWebsite.service.compare',
    '$window',
    '$rootScope',
    function (productLogic, compare, $window, $rootScope) {
        return {
            restrict: 'A',
            link: function ($scope, element, attributes) {

                element.bind('click', function () {
                    compare.addCompareItem ({
                        product_id: attributes.productId
                    }).success(function () {
                        if (attributes.autoredirect)
                        {
                            $window.location = attributes.location;
                        }
                        else
                        {
                            $rootScope.$broadcast('store.cart.updatedCompare');
                        }
                    });
                });
            }
        }
    }
]);

/**
 * Product Add to Wish List Button Action
 */
angular.module('StoreWebsite.widget.store_product').directive ('storeProductAddToWishlist', [
    'StoreWebsite.service.productLogic',
    'StoreWebsite.service.wish',
    '$window',
    '$rootScope',
    function (productLogic, wish, $window, $rootScope) {
        return {
            restrict: 'A',
            link: function ($scope, element, attributes) {

                element.bind('click', function () {
                    wish.addWishItem ({
                        product_id: attributes.productId
                    }).success(function () {
                        if (attributes.autoredirect)
                        {
                            $window.location = attributes.location;
                        }
                        else
                        {
                            $rootScope.$broadcast('store.cart.updatedWish');
                        }
                    });
                });
            }
        }
    }
]);

angular.module('StoreWebsite.widget.store_product').directive ('productOptions', [
    'StoreWebsite.service.product',
    'StoreWebsite.service.productLogic',

    function (product, productLogic) {

        return {
            restrict: 'E',
            scope: false,
            replace: false,
            template: '<div ng-repeat="option in productOptions|orderBy:\'position\'" class="form-group">' +
                '<label ng-bind="option.name"></label>' +
                '<select class="product-options-dopdown {{selectclass}}" required ng-change="applyCombination()" ng-model="option.selectedValue" ng-options="v.id as v.name for (k, v) in option.values">' +
                '</select>' +
                '</div>',
            link: function (s, e, a) {
                s.selectclass = ($(e).attr('selectclass'));

                var combinations = [];
                s.productOptions = [];

                /**
                 * Get variant by id
                 * @param vid
                 * @returns {*}
                 */
                function selectVariant (vid) {
                    for (var i in s.variants) {
                        if (s.variants [i].id == vid) {
                            return s.variants [i];
                        }
                    }
                    return {};
                }


                /**
                 * Search variant by combination
                 * @param options
                 * @returns {*}
                 */
                function searchVariant (options) {
                    var compareObject = {};

                    angular.forEach (options, function (option, id) {
                        compareObject[option.id] = option.selectedValue;
                    });

                    for (var vid in combinations) {
                        if (angular.equals(combinations[vid], compareObject)) {
                            return selectVariant (vid);
                        }
                    }
                    return {};
                }



                /**
                 * Fetch product variants
                 */
                product.getVariants ({product_id: a.productId, finalize_price: 1})
                    .success(function (variants) {
                        /**
                         * Create combination array for compare
                         */

                        var opt = {};
                        productLogic.setVariants(variants);

                        variants.forEach (function (variant) {


                            var combination = {};
                            
                            variant.options.forEach(function (vo) {

                                combination [vo.option_id] = vo.value_id;

                                // Option
                                opt[vo.option_id] = opt[vo.option_id] || vo.option;
                                // Create Values List or use exists
                                opt[vo.option_id] ['values'] = opt [vo.option_id]['values'] || {};
                                // Make First Selected
                                opt[vo.option_id].selectedValue = opt[vo.option_id].selectedValue || vo.value.id;
                                // Add value to the values list
                                opt[vo.option_id] ['values'][vo.value.id] = vo.value;
                            });

                            combinations [variant.id] = combination;
                        });

                        function containsObject(obj, list) {
                            var i;
                            for (i = 0; i < list.length; i++) {
                                if ( JSON.stringify(list[i]) === JSON.stringify(obj) ) {
                                    return true;
                                }
                            }

                            return false;
                        }

                        angular.forEach(opt, function(element) {
                            var tmp_options  = [];
                            s.productOptions.forEach(function (pr_opt) {
                                var tmp_pr_opt = angular.copy(pr_opt);
                                tmp_options.push(tmp_pr_opt);
                            });
                            var tmp_element = angular.copy(element);
                            if ( !containsObject(tmp_element,tmp_options)){
                                s.productOptions.push(element);
                            }
                        });

                        s.variants = variants;

                        /**
                         * Set default variant
                         * @type {*}
                         */
                        s.applyCombination ();
                    });
                product.getCurrency ()
                    .success(function (currency) {
                        productLogic.setCurrency(currency);
						productLogic.broadcastPriceUpdate();
                    });


                /**
                 * On combinations change;
                 */
                s.applyCombination = function () {

                    s.variant = searchVariant (s.productOptions);
                    productLogic.setVariant(s.variant);
                };
            }
        };

    }
]);


angular.module('StoreWebsite.widget.store_product').directive ('productCustomOptions', [
    'StoreWebsite.service.product',
    'StoreWebsite.service.productLogic',
    'Upload',
    function (product, productLogic, Upload) {

        return {
            restrict: 'E',
            scope: false,
            replace: false,
            template: '<div ng-repeat="option in productCustomOptions|orderBy:\'position\'" class="form-group">' +
                '<div ng-if="option.type == null" class="moto-widget-contact_form-group moto-spacing-bottom-small">'+
                '<label ng-bind="option.name"></label>' +
                '<input type="text" class="product-options" ng-model="option.value" ng-change="pushCustomOptions()">' +
                '</div>' +
                '<div ng-if="option.type == \'checkbox\'" class="moto-widget-contact_form-group moto-spacing-bottom-small">'+
                '<input type="checkbox"  ng-model="option.value" ng-change="pushCustomOptions()">'+
                '<label class="moto-widget-store-checkout-form-radio_label {{ currentWidget.properties.preset }}" ng-bind="option.name"></label>'+
                '</div>' +
                '<div ng-if="option.type == \'text\'" class="moto-widget-contact_form-group moto-spacing-bottom-small">'+
                '<label ng-bind="option.name"></label>' +
                '<input type="text" class="product-options" ng-model="option.value" ng-change="pushCustomOptions()">' +
                '</div>' +
                '<div ng-if="option.type == \'textarea\'" class="moto-widget-contact_form-group moto-spacing-bottom-small">'+
                '<label ng-bind="option.name"></label>' +
                '<textarea class="product-options" ng-model="option.value" ng-change="pushCustomOptions()"></textarea>' +
                '</div>' +
                /*'<div ng-if="option.type == \'file\'" class="moto-widget-contact_form-group moto-spacing-bottom-small store-custom-options-file">' +
                '<div class="container-fluid">' +
                '<label ng-bind="option.name"></label>' +
                '<div class="row">' +
                '<div class="moto-cell col-xs-6">' +
                '<input type="text" class="product-options" readonly="readonly" placeholder=""  ng-model="option.value"/>' +
                '</div>' +
                '<div class="moto-cell col-xs-6 store-custom-options-file-column">' +
                '<div class="moto-widget moto-widget-button  moto-preset-{{ btn_preset }}" >' +
                '<button type="button" ngf-select="uploadFile($file, option)" class="moto-widget-button-link moto-size-{{ btn_size }}" >' +
                '<span class="fa moto-widget-theme-icon"></span><span class="moto-widget-button-label">{{btn_text}}</span' +
                '</button>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>' +*/
                '</div>',
            link: function (s, e, a) {

                var combinations = [];
                s.productCustomOptions = [];
                s.btn_size = ($(e).attr('btnsize'));
                s.btn_preset = ($(e).attr('btnpreset'));
                s.btn_text = ($(e).attr('btntext'));
                s.pushCustomOptions = function () {
                    productLogic.setCustomOptions(s.productCustomOptions);
                };
                s.uploadFile = function ($file, option) {
                    Upload
                        .upload({
                            method: 'POST',
                            url: product.getApiPath(),
                            file: $file,
                            data: {
                                jsonrpc: '2.0',
                                id: 1,
                                method: 'store_cart_service.uploadFile',
                                params: {}
                            },
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        })
                        .success(function (data) {
                            option.value = data.result.file;
                            s.pushCustomOptions();
                        })
                        .error(function (data) {

                        });

                };

                /**
                 * Fetch product variants
                 */
                product.getCustomOptions ({product_id: a.productId,})
                    .success(function (options) {

                        s.productCustomOptions = options;
                    });
                product.getCurrency ()
                    .success(function (currency) {
                        productLogic.setCurrency(currency);
                        productLogic.broadcastPriceUpdate();
                    });


            }
        };

    }
]);

angular.module('StoreWebsite.widget.store_product').directive ('productCustomOptionsCheckbox', [
    'StoreWebsite.service.product',
    'StoreWebsite.service.productLogic',
    'Upload',
    'jsonrpc',
    function (product, productLogic, Upload,jsonrpc) {

        return {
            restrict: 'E',
            scope: false,
            replace: false,
            template: '<div ng-repeat="option in productCustomOptions|orderBy:\'position\'" class="form-group moto-spacing-bottom-small">' +
                            '<div ng-if="option.type == null" class="moto-widget-contact_form-group">'+
                                '<input type="checkbox"  ng-model="option.value" ng-change="pushCustomOptions()">'+
                                '<label class="moto-widget-store-checkout-form-radio_label {{ currentWidget.properties.preset }}" ng-bind="option.name"></label>'+
                            '</div>' +
                            '<div ng-if="option.type == \'checkbox\'" class="moto-widget-contact_form-group moto-spacing-bottom-small">'+
                                '<input type="checkbox"  ng-model="option.value" ng-change="pushCustomOptions()">'+
                                '<label class="moto-widget-store-checkout-form-radio_label {{ currentWidget.properties.preset }}" ng-bind="option.name"></label>'+
                            '</div>' +
                            '<div ng-if="option.type == \'text\'" class="moto-widget-contact_form-group">'+
                                '<label ng-bind="option.name"></label>' +
                                '<input type="text" class="product-options" ng-model="option.value" ng-change="pushCustomOptions()">' +
                            '</div>' +
                            '<div ng-if="option.type == \'textarea\'" class="moto-widget-contact_form-group moto-spacing-bottom-small">'+
                                '<label ng-bind="option.name"></label>' +
                                '<textarea rows="3" class="product-options" ng-model="option.value" ng-change="pushCustomOptions()"></textarea>' +
                            '</div>' +
                           /* '<div ng-if="option.type == \'file\'" class="moto-widget-contact_form-group moto-spacing-bottom-small store-custom-options-file">' +
                                '<div class="container-fluid">' +
                                    '<label ng-bind="option.name"></label>' +
                                    '<div class="row">' +
                                        '<div class="moto-cell col-xs-6">' +
                                            '<input type="text" class="product-options" readonly="readonly" placeholder=""  ng-model="option.value"/>' +
                                        '</div>' +
                                        '<div class="moto-cell col-xs-6 store-custom-options-file-column">' +
                                            '<div class="moto-widget moto-widget-button moto-preset-{{ btn_preset }} " >' +
                                                '<button type="button" ngf-select="uploadFile($file, option)" class="moto-widget-button-link  moto-size-{{ btn_size}}" >' +
                                                    '<span class="fa moto-widget-theme-icon"></span><span class="moto-widget-button-label">{{btn_text}}</span' +
                                                '</button>' +
                                            '</div>' +
                                        '</div>' +
                                    '</div>' +
                                '</div>' +
                            '</div>' +*/
                        '</div>',

            link: function (s, e, a) {
                s.btn_size = ($(e).attr('btnsize'));
                s.btn_preset = ($(e).attr('btnpreset'));
                s.btn_text = ($(e).attr('btntext'));
                var combinations = [];
                s.productCustomOptions = [];

                s.pushCustomOptions = function () {
                    productLogic.setCustomOptions(s.productCustomOptions)
                };
                s.uploadFile = function ($file, option) {
                    Upload
                            .upload({
                                method: 'POST',
                                url: product.getApiPath(),
                                file: $file,
                                data: {
                                    jsonrpc: '2.0',
                                    id: 1,
                                    method: 'store_cart_service.uploadFile',
                                    params: {}
                                },
                                headers: {
                                    'X-Requested-With': 'XMLHttpRequest'
                                }
                            })
                            .success(function (data) {
                                option.value = data.result.file;
                                s.pushCustomOptions();
                            })
                            .error(function (data) {

                            });

                };
                /**
                 * Fetch product variants
                 */
                product.getCustomOptions ({product_id: a.productId,})
                    .success(function (options) {

                        s.productCustomOptions = options;
                    });
                product.getCurrency ()
                    .success(function (currency) {
                        productLogic.setCurrency(currency);
                        productLogic.broadcastPriceUpdate();
                    });


            }
        };

    }
]);


angular.module('StoreWebsite.widget.store_product').directive ('storeLightboxGallery', [
    function () {
        return {
            restrict: 'A',
            link: function (scope, element, attributes) {
                if ($().magnificPopup) {
                    element.magnificPopup({
                        delegate: 'a.moto-widget-image-link',
                        type: 'image',
                        gallery: {
                            enabled: true
                        }
                    });
                } else {
                    element.on('click', 'a.moto-widget-image-link', function(e) {
                        e.preventDefault();
                    });
                }
            }
        };
    }
]);



