'use strict';

angular.module('application.widget.store.product_related_products', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            /**
             * @param $scope
             * @param ProductService
             * @constructor
             */
            function Controller($scope, ProductService, DesignColorizerModel)
            {

                var widget = $scope.currentWidget,
                    f = {
                        count: widget.properties.per_page,
                        page: 1,
                        order: [{
                            order: 'created_date',
                            direction: 'desc'
                        }]
                    };



                function getCollection (f)
                {
                    ProductService.getCollection (f)
                        .success(function (data) {
                            widget.related_products = data.collection;
                            $scope.currentWidget.__getInternalInstance().related_products = data.collection;
                            widget.renderPreview();
                        });
                }
                function getColorByName (name)
                {
                    if (name && $scope.systemColors) {
                        if (name.indexOf('@baseColor') >= 0) {
                            var keys = name.replace('@baseColor', '').split('_');
                            return $scope.systemColors.base[keys[0]][parseInt(keys[1])];
                        } else if (name.indexOf('@customColor') >= 0) {
                            return $scope.systemColors.custom[name.replace('@customColor', '')];
                        } else {
                            return name;
                        }
                    } else {
                        return '';
                    }
                }

                DesignColorizerModel
                    .success(function() {
                        var item;

                        if (item = DesignColorizerModel.objects().first()) {
                            $scope.systemColors = item;
                        }
                    })
                    .error(function() {
                        $scope.systemMessenger.error('COMMON.ERROR.UNABLE_TO_GET_DATA');
                    })
                    .load();

                getCollection (f);
                /**
                 *
                 */
                $scope.$on('widgetPropertiesChanged', function (e, newValue, oldValue) {
                    if ($scope.currentWidget && $scope.currentWidget.name == 'store_product_related_products') {
                        $scope.currentWidget.__getInternalInstance().properties.labelHexColor = getColorByName(newValue.labelColor.background);
                        var data = {
                            count: $scope.currentWidget.__getInternalInstance().properties.per_page,
                            page: 1,
                            order: [{
                                order: 'created_date',
                                direction: 'desc'
                            }]
                        };
                        getCollection (data);
                        widget.renderPreview();
                    }
                });

            }

            Controller.$inject = ['$scope', 'store.product.services.ProductService', 'application.design.colorizer.DesignColorizerModel',];

            function classWidget() {

                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    row_size: '4',
                    per_page: 4,
                    thumbnail: {
                        hide: false,
                        zoom: false,
                        preset: 'default'
                    },
                    labelColor: {
                        background: null
                    },
                    labelHexColor: null,
                    wrapWord: true,
                    button: {
                        active: false,
                        size: 'medium',
                        preset: 'default',
                        text: 'Add to cart'
                    },
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.related_products = [];
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.name = 'store_product_related_products';
            classWidget.prototype.label = 'EDITOR.WIDGETS.PRODUCT_RELATED_PRODUCTS.LABEL';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_product/views/' + classWidget.prototype.name + '/properties.tpl.html';
            classWidget.prototype.templateUrl = function (){
                return '@plugins/moto-store-plugin/app/widgets/store_product/presets/'  + this.name + '/' + this.properties.preset + '/template.html.twig';
            };

            classWidget.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_product/icons/drag-store-product-related-products.png';
            classWidget.prototype.product = null;
            classWidget.prototype.controller = Controller;
            classWidget.prototype.allow = ['section', 'container'];

            classWidget.prototype.deleteAllAlignClasses= function(){
                var self = this,
                    alignments = ['left', 'center', 'right'];

                for(var device in self.properties.align){
                    alignments.forEach(function(align){
                        if(device == 'desktop'){
                            self.$(self._dom).removeClass('moto-align-' + align );
                        }else{
                            self.$(self._dom).removeClass('moto-align-' + align + '_' + device);
                        }
                    });
                }
            };

            classWidget.prototype.setAlignObject = function(){
                var self = this;

                if (self.properties && self.properties.align && (typeof self.properties.align == 'object')) {
                    self.deleteAllAlignClasses();

                    self.$(self._dom).addClass('moto-align-' + (self.properties.align['desktop']));
                    if (self.properties.align['tablet']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['tablet']) + '_tablet');
                    if (self.properties.align['mobile-h']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-h']) + '_mobile-h');
                    if (self.properties.align['mobile-v']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-v']) + '_mobile-v');
                }
            };

            classWidget.prototype.getRenderVariables = function () {
                var self = this;
                return {
                    currentWidget: self,
                    related_products: self.related_products,
                };
            };

            classWidget.prototype.update = function () {

                var self = this;

                if (self.properties.align) {
                    self.$(self._dom).removeClass('moto-align-left');
                    self.$(self._dom).removeClass('moto-align-right');
                    self.$(self._dom).removeClass('moto-align-center');

                    self.$(self._dom).attr('data-align', JSON.stringify(self.properties.align));
                }

                self.setAlignObject();
                AbstractWidgetClass.prototype.update.call(this);
            };

            classWidget.prototype.initialize = function () {
                var self = this;

                var propertiesNode = self.$('script[type="text/widget-properties"]', self._dom);

                if (propertiesNode.length) {
                    var properties;

                    try {
                        properties = angular.fromJson(propertiesNode.text().trim());
                    } catch (ignored) {
                    }

                    if (angular.isObject(properties)) {
                        jQuery.extend(true, self.properties, properties);
                    }

                }

                if(typeof self.properties.align == 'string') {
                    self.properties.align = {
                        "desktop": self.properties.align,
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    };
                }

                try{
                    self.properties.align = JSON.parse(self.$(self._dom).data('align'));
                }catch (ev){
                    self.properties.align = self.$(self._dom).data('align') || self.properties.align;
                }


                self.setAlignObject();

                AbstractWidgetClass.prototype.initialize.call(this);
            };

            classWidget.prototype._transformToMacros = true;

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: 'store_product_related_products',
                label: 'EDITOR.WIDGETS.PRODUCT_RELATED_PRODUCTS.LABEL',
                category: "store",
                order: 22,
                enabled: true,
                allowed: function (page, sectionName) {
                    return "template.store.product" == page.type &&  sectionName == "content";
                },
                icons: {
                    small: 'icon icon-store-product-related-products',
                    medium: '',
                    large: 'icon icon-store-product-related-products'
                }
            });
        }
]);
