<?php
namespace Website\Widgets\StoreProductGridCustom;

use Doctrine\ORM\Query\Expr\Join;
use Moto;
use MotoStore\Collection\Collection;
use MotoStore\Collection\Query\Param;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Content\Helper\Pagination;
use MotoStore\Content\Widget\AbstractWidget;
use MotoStore\Order\Cart\Storage;
use MotoStore\Product\Entity\Category;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Currency;
use MotoStore\Settings\Entity\Option;
use Zend\Http\PhpEnvironment\Request;

class Widget extends AbstractWidget
{
    protected $_name = 'store_product_grid_custom';

    /**
     * Products Collection
     * @var array
     */
    protected $products = array ();
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'row_size' => 3,
        'thumbnail' => array(
            'hide' => false,
            'zoom' => false,
            'preset' => 'default'
        ),
        'product_title_style' => '',
        'product_price_style' => '',
        'labelColor' => array(
            'background' => null
        ),
        'labelHexColor' => null,
        'wrapWord' =>  true,
        'button' => array(
            'active' => false,
            'size' => 'medium',
            'preset' => 'default',
            'text' => 'Add to cart'
        ),
        'auto_redirect' => true,
        'use_thumbnails' => false,
        'selected_products' => array (),
);

    /**
     * @var []
     */
    public $currency;


    protected $_widgetId = true;

    /**
     * @param array $options
     */
    /**
     * @return array
     */
    public function getRenderVariables()
    {
        $this->currency = $this->getDisplayCurrency ();
        $this->products_ids= $this->getOption('selected_products');
        $this->products  = array();
        foreach ($this->products_ids as $products_id) {
            $this->products [] = $this->getProduct($products_id['id']);
        }
        if ($this->_options['use_thumbnails']){
         //   $this->applyThumbnails ();
        }

        $this->wrapWord = isset ($this->_options ['wrapWord'])
            ? $this->_options ['wrapWord']
            : true;
        if($this->isCatalogModeEnabled()){
            $this->properties->hide_prices = true;
            $this->properties['hide_prices'] = true;
        }
        return array (
            'currentWidget'        => $this,
            'currencies'    => $this->getCurrencyList (),
            'products'      => $this->products,
        );
    }

    public function isCatalogModeEnabled(){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $catalog_mode = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode');
        return !!$catalog_mode;
    }

    public function getProduct ($id)
    {
      $product = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->getProductById ($id);


        $customerDiscount = $this->getCustomerDiscount();
        if( $product && $customerDiscount){
            $tmpPrice = $product->getPrice();
            $product->setHasSpecialPrice(true);
            $product->setSpecialDateStart(new \DateTime('-1 day'));
            $product->setSpecialDateEnd(new \DateTime('+1 day'));
            $product->setSpecialPrice($tmpPrice - $tmpPrice*$customerDiscount/100);

        }
        return $product;
    }
    protected function getCurrencyList ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getActiveCurrenciesList ();
    }

    public function applyThumbnails()
    {
        $tmpProducts = $this->products;
        foreach ($tmpProducts as $key => $product) {
            $this->products[$key]->attachMainImage($this->getThumbnail($product->getImage(), $this->_options['tumbnail_size']));
        }

    }

    public  function getThumbnail($image,$thumbnail_size){
        $imageThubmnails = json_decode($image->getThumbnails(),true);
        if (isset($imageThubmnails[$thumbnail_size])){
            $pathInfo = pathinfo($image->getPath());
            $thumbnailPath  = $pathInfo['dirname'] .
                '/thumbnails/' .
                $pathInfo['filename'] .
                '_' .
                $thumbnail_size .
                '_' .
                $imageThubmnails[$thumbnail_size]['width'] .
                'x' .
                $imageThubmnails[$thumbnail_size]['height'].
                '.' .
                $pathInfo['extension'];
            $filepath = Moto\System::getUploadAbsolutePath($thumbnailPath);
            if(file_exists($filepath)){
                $image->setPath($thumbnailPath);
            }
        }
        return $image;
    }

    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/default/template.html.twig';
        return $template;
    }


    /**
     * @return Currency
     */
    protected function getDisplayCurrency ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getDisplayCurrency ();
    }


    protected  function isCustomerBtob()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();
        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                return (bool)$customer->getBtob ();
            }
        }
        return false;

    }

    protected  function getCustomerDiscount()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();
        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                $discount = $customer->getLoyaltyDiscount();
                if($discount && $discount > 0 && $discount < 100){
                    return $discount;
                } else {
                    return false;
                }
            }
        }
        return false;

    }

}