<?php
namespace Website\Widgets\StoreSearch;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_search';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'buttons' => array(
            'search' => array(
                'preset' => 'default',
                'text' => 'Search'
            ),

        ),
    );
    
    /**
     * @return array
     */
    public function getRenderVariables()
    {
        $vars = parent::getRenderVariables ();
        $vars['keyword'] = Moto\System\Request::getQuery ('keyword', '');

        return $vars;
    }


    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}