/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

angular.module('StoreWebsite').service ('StoreWebsite.service.search', [
    'jsonrpc',

    function (jsonrpc) {
        var service = jsonrpc.newService('store_cart_service');

        this.search    = service.createMethod('search');
    }
]);

angular.module('StoreWebsite').directive ('storeSearchWidget', [
    'StoreWebsite.service.search',
    function (search) {

        return {
            restrict: 'A',

            link: function ($scope, element, attributes) {

                var toggle       = element.find('.search-form_toggle'),
                    searchInput  = element.find('.search-form_input'),
                    searchForm   = element.find('.search-form'),
                    searchButton = element.find('.search-form_submit');

                toggle.bind('click', function() {
                    toggle.toggleClass('active');
                    searchForm.toggleClass('on');

                    if (!searchForm.hasClass('active')) {
                        searchInput.focus();
                    }
                });


                searchButton.bind ('click', function () {
                    if (searchInput.val()) {
                        searchForm.submit();
                    }
                });
            }
        };
    }
]);
