<?php

namespace Website\Widgets\StoreWorkingHours;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Settings\Entity\Option;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_working_hours';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset' => 'default',
        'align' =>  array(
            "desktop"=> 'left',
            "tablet"=> '',
            "mobile-h"=> '',
            "mobile-v"=> ''
        ),
        'widget_title' => 'My Cart',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'heading_style' =>'moto-text_normal',
        'row_style' => 'moto-text_normal',
        'show_week_day' => true,
        'days_title' =>'Days',
        'hours_title' =>'Opened Hours',
        'monday' => 'Monday',
        'tuesday' => 'Tuesday',
        'wednesday' => 'Wednesday',
        'thursday' => 'Thursday',
        'friday' => 'Friday',
        'saturday' => 'Saturday',
        'sunday' => 'Sunday'
    );
    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        return '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
    }


    public function getRenderVariables ()
    {

        return array_merge(
            array (
                'shedule' => $this->getShedule (),
                'tmp_shedule' => $this->getTmpShedule (),
            ), parent::getRenderVariables());
    }

    protected function getShedule()
    {
        $shedule = array();
        for($i=0; $i<7; $i++){
            $shedule []= $this->getSheduleRow($i);
        }
        return $shedule;
    }

    protected function getTmpShedule()
    {
        $days = array('Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday');
        $days_localized = array(
            $this->properties['monday'],
            $this->properties['tuesday'],
            $this->properties['wednesday'],
            $this->properties['thursday'],
            $this->properties['friday'],
            $this->properties['saturday'],
            $this->properties['sunday']
        );
        $shedule = array();
        for($i=0; $i<7; $i++){
            $row['from'] = '08:00';
            $row['to'] = '18:00';
            $row['delimiter'] = '-';
            $row['day'] = '0'. ($i+1) .'-01-1970';
            $row['dayname'] = $days[$i];
            $row['localized_dayname'] = $days_localized[$i];
            $shedule []= $row;
        }
        return $shedule;
    }

    protected function getSheduleRow($offset)
    {
        $dateformat = $this->getDateFormat();
        $timeformat = ("H:i");
        $row = array();
        $row ['day'] = date($dateformat, strtotime("+".$offset." day"));
        $row ['dayname'] = date('l ', strtotime("+".$offset." day"));
        $row ['localized_dayname'] = $this->properties[strtolower(date('l', strtotime("+".$offset." day")))];
        $openedHours = $this->getOpenedHours($offset,$timeformat);
        $row ['from'] = $openedHours ['from'];
        $row ['to'] =  $openedHours ['to'];
        $row['delimiter'] = strpos($openedHours ['from'],'-') > 0 ? ' ' : '-' ;
        return $row;
    }

    protected function getOpenedHours ($offset,$timeformat)
    {
        $day_week_array = array('sunday','monday','tuesday','wednesday','thursday','friday','saturday');
        $now_date = date('Y-m-d',strtotime("+".$offset." day"));
        $now_weekday = date('w',strtotime("+".$offset." day"));
        $custom_open = json_decode($this->getCustomOpen(),true);
        $closed = json_decode($this->getClosedTimes(),true);
        krsort($closed);
        $open_from = '-';
        $open_to = '-';
        $need_check_custom_open = false;
        foreach ($custom_open as $custom_open_date){
            if (
                isset($custom_open_date['date'])
                && isset($custom_open_date['from'])
                && isset($custom_open_date['to'])
                && ( $now_date == date('Y-m-d', strtotime($custom_open_date['date'])))
            )
            {
                $need_check_custom_open = true;
                $open_from = date($timeformat, strtotime($custom_open_date['from']));
                $open_to = date($timeformat, strtotime($custom_open_date['to']));
            }
        }

        if(!$need_check_custom_open) {
            $standart_open = json_decode($this->getStandartOpen(), true);
            $curent_standart_item = $standart_open[$day_week_array[$now_weekday]];
            if ( isset($curent_standart_item['from']) && isset($curent_standart_item['to']) && isset($curent_standart_item['to'])&& ($curent_standart_item['enabled'] == 'true'))
            {
                $open_from = date($timeformat, strtotime($curent_standart_item['from']));
                $open_to = date($timeformat, strtotime($curent_standart_item['to']));
            }
        }
        $closed_from = '0';
        $closed_to = '0';
        foreach ($closed as $closed_item){
            if (
                isset($closed_item['day'])
                && isset($closed_item['from'])
                && isset($closed_item['to'])
            )
            {
                $need_to_add_closed = false;
                if  ( $need_check_custom_open && ('custom_date' == $closed_item['day']))
                {
                    $closed_from = date($timeformat, strtotime($closed_item['from']));
                    $closed_to = date($timeformat, strtotime($closed_item['to']));
                    $need_to_add_closed = true;
                }
                else if( $closed_item['day'] == $day_week_array[$now_weekday])
                {
                    $closed_from = date($timeformat, strtotime($closed_item['from']));
                    $closed_to = date($timeformat, strtotime($closed_item['to']));
                    $need_to_add_closed = true;
                }
                if ($open_from < $closed_from && $open_to > $closed_from &&  $need_to_add_closed === true){
                    $open_from = $open_from . '-' . $closed_from;
                    if($open_to > $closed_to){
                        $open_to = $closed_to . '-' . $open_to;
                    }
                    break;
                }
            }

        }
        if ($open_from == '-'){
            $open_from = '';
        }
        if ($open_to == '-'){
            $open_to = '';
        }
        return array( 'from' => $open_from, 'to' => $open_to) ;
    }

    protected function getIsEnabledWorkingHours ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'enable_workinghours');
    }

    protected function getDateFormat ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $dateFormat = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'date_format');
        if (!$dateFormat){
            $dateFormat = "Y-m-d";
        }
        return $dateFormat;
    }

    protected function getTimeFormat ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $timeFormat = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'time_format');
        if (!$timeFormat){
            $timeFormat = "H:m";
        }
        return $timeFormat;
    }

    protected function getIsEnablsssssdWorkingHours ()
    {
        $optRepository =  SMStatic::getInstance ()
        ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close_shop_now');
    }

    protected function getStandartOpen ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'standart_open');
    }

    protected function getCustomOpen ()
    {
        $optRepository =  SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'custom_open');
    }
    protected function getClosedTimes ()
    {
        $optRepository =  SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close');
    }
}
