<?php
$websiteRootPath = __DIR__;
for ($i = 0; $i < 5; $i++) {
    if (file_exists($websiteRootPath . '/common.php')) {
        include_once $websiteRootPath . '/common.php';
        break;
    }
    $websiteRootPath = dirname($websiteRootPath);
}

echo '<pre>';

if (!class_exists('Moto\\System', false)) {
    echo '<b>ERROR</b>: Moto Engine not found';
    exit;
}

$manualInstaller = new ManualInstall();

$action = Moto\Util::getValue($_GET, 'action', 'install');
switch ($action) {
    case 'install':
        $manualInstaller->doInstallAction();
        break;
    default:
        echo "<hr>\n";
        echo "<b>ERROR:</b> Unknown action [ $action ]\n";
        exit;
        break;
}

class ManualInstall
{
    const MIN_ENGINE_VERSION = '3.4.0';
    const MIN_ENGINE_BUILD = 390;
    const PLUGIN_NAME = 'moto-store-plugin';

    protected $_currentEngineVersion;
    protected $_currentEngineBuild;
    protected $_currentFile;

    public function __construct()
    {
        $this->_currentEngineVersion = Moto\System\Settings::get('version');
        $this->_currentEngineBuild = Moto\System\Settings::get('build');
        $this->_currentFile = basename(__FILE__);
    }

    public function getCheckingErrors()
    {
        $errors = [];
        if ($this->_currentEngineBuild < static::MIN_ENGINE_BUILD) {
            $errors[] = 'Sorry, but engine version is to low, need version ' . static::MIN_ENGINE_VERSION . ', build ' . static::MIN_ENGINE_BUILD;
        }

        return $errors;
    }

    public function doInstallAction()
    {
        echo "Current Engine version: <b>{$this->_currentEngineVersion}</b>\n";
        echo "Current Engine build: <b>{$this->_currentEngineBuild}</b>\n";
        echo "Installing...\n";

        echo "\tChecking... ";
        $errors = $this->getCheckingErrors();
        echo "DONE\n";
        if (count($errors)) {
            echo "<hr>\n";
            echo "<b>ERRORS:</b>  \n";
            print_r($errors);
            exit;
        }

        echo "\tTry to register plugin...\n";
        try {

            if (Moto\System\PluginManager::isActivated(static::PLUGIN_NAME)) {
                echo "\t\tDisable plugin ... ";
                Moto\System\PluginManager::deactivate(static::PLUGIN_NAME);
                echo "Done\n";
            }

            if (method_exists('Moto\System\PluginManager', 'install')) {
                if (Moto\System\PluginManager::isInstalled(static::PLUGIN_NAME)) {
                    echo "\t\tUninstall plugin ... ";
                    Moto\System\PluginManager::uninstall(static::PLUGIN_NAME);
                    echo "Done\n";
                }
                echo "\t\tInstall plugin ... ";
                Moto\System\PluginManager::install(static::PLUGIN_NAME);
                echo "Done\n";
                echo "\t\tActivate plugin ... ";
                Moto\System\PluginManager::activate(static::PLUGIN_NAME);
                echo "Done\n";
            } else {
                echo "\t\tActivate plugin ... ";
                Moto\System\PluginManager::activate(static::PLUGIN_NAME);
                echo "Done\n";
            }

        } catch (\Exception $e) {
            echo "\n<b>FAILED</b>\n";
            echo "Exception: " . $e->getMessage() . "\n";
            echo $e->getTraceAsString();
            if ($e instanceof Moto\System\Exception) {
                print_r($e->getErrors());
            }
            exit;
        }
        echo "\nDONE\n";
    }
}
