<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Collection;


abstract class AbstractExport implements ExportInterface
{
    /**
     * Target File
     * @var string
     */
    protected $target;

    /**
     * Collection to Export
     * @var Collection
     */
    private $collection;

    /**
     * Target resource
     * @var
     */
    private $resource;

    /**
     * CSV delimiter
     * @var string
     */
    private $delimiter = ',';

    /**
     * CSV enclosure
     * @var string
     */
    private $enclosure = '"';

    /**
     * AbstractExport constructor.
     * @param $target
     * @param Collection $collection
     */
    public function __construct ($target, Collection $collection)
    {
        $this->target = $target;
        $this->collection = $collection;
    }

    public function export ()
    {
        $this->open ();

        $records = $this->collection
            ->getCollection (array ($this, 'prepareRecord'));

        $this->write ($this->getHeaders ());

        foreach ($records as $record)
        {
            $this->write ($this->excludeFields ($record));
        }
        $this->close ();
    }

    /**
     * @param $record
     * @return mixed
     */
    public function prepareRecord ($record)
    {
        return $record;
    }

    /**
     * Filter record by headers
     * @param $record
     * @return array
     */
    private function excludeFields ($record)
    {
        $headers = array_flip ($this->getHeaders ());

        return array_intersect_key (array_merge ($headers, $record), $headers);
    }

    /**
     * Create Target Resource
     */
    private function open ()
    {
        $this->resource = fopen ($this->target, 'w');
    }

    /**
     * Write record to CSV
     * @param array $record
     */
    private function write (array $record)
    {
        fputcsv ($this->resource, $record, $this->delimiter, $this->enclosure);
    }

    /**
     * Close resource
     */
    private function close ()
    {
        return fclose ($this->resource);
    }
}