<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content;

use Moto;
use Moto\System;
use MotoStore\Content\Application\StoreApplication;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Platform\Module\ModuleAbstract;
use Zend\EventManager\Event;

class Module extends ModuleAbstract
{
    const MOTO_STORE_APPLICATION_NAME = 'MotoStore';
    /**
     * Return module config
     *
     * @return array
     */
    public function getModuleConfig ()
    {
        return include __DIR__ . DIRECTORY_SEPARATOR .  'config' . DIRECTORY_SEPARATOR . 'module.config.php';
    }

    /**
     * Module Name
     * @return string
     */
    public function getName ()
    {
        return 'Content';
    }

    public function bootstrap ()
    {
        $serviceLocator = $this->getServiceLocator ();
        $t = $serviceLocator->get ('store.twig');
        $t->addExtension (new \MotoStore\Content\Helper\Twig\StoreTwigExtension ());
        $this->bootstrapLinker ();

        $this->getEventManager ()->attach ('store.event.modules.loaded',
                function (Event $e) use ($serviceLocator)
                {
                    // create static service locator
                    {
                        SMStatic::create ($serviceLocator);
                    }

                    $applicationClass   = 'MotoStore\Content\Application\StoreApplication';

                    $routes = array (
                        '/store/',
                        '/store/*'
                    );

                    if (!System\Request::getQuery('mode') == 'preview' && StoreApplication::isHome ())
                    {
                        array_push ($routes, '');
                        array_push ($routes, '/');
                    }

                    System::registerApplication ($applicationClass, $applicationClass, $routes);
                }
            );
    }

    private function bootstrapLinker ()
    {
        Moto\ClickAction\Factory::init ();
        Moto\ClickAction\Factory::setClickAction ('store.home', array (
            'renderClass' => 'MotoStore\Content\Linker\StoreLink',
            'filter' => function ($value) {
                return $value;
            },
            'validator' => function () {
                return true;
            },
        ));
    }
}