<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Application;


use Felipecwb\Routing\Router;
use Moto\Website\Application;
use Zend\Http\Response;

class AbstractApplication extends Application
{

    /** @var  Router */
    protected $router;

    /**
     * @return null|string
     */
    public static function getRequestUrl ()
    {
        $url = \Moto\System\Request::getRequestUrl ();

        if (substr ($url, 0, 1) != '/')
        {
            $url = '/' . $url;
        }
        return rtrim ($url, '/');
    }

    /**
     * @return array|\ArrayObject|null
     * @throws \Moto\Json\Server\Exception
     */
    public function getNotFoundPage ()
    {

        $notFoundPageId = \Moto\Website\Settings::get ('notfound_page_id');
        $this->getResponse ()->notFound ();
        if ($notFoundPageId)
        {
            return  \Moto\Application\Pages\Service::getById( $notFoundPageId);
        }
        $this
            ->getResponse ()
            ->setStatusCode (Response::STATUS_CODE_404);
    }
    /**
     * @return array|\ArrayObject|null
     * @throws \Moto\Json\Server\Exception
     */
    public function getUnderConstructionPage ()
    {
        $underconstruction_setting = (array)\Moto\Website\Settings::get ('under_construction');
        $notFoundPageId = $underconstruction_setting['page_id'];
        // $notFoundPageId = \Moto\Website\Settings::get ('notfound_page_id');
        $this->getResponse ()->notFound ();
        if ($notFoundPageId)
        {
            return  \Moto\Application\Pages\Service::getById( $notFoundPageId);
        }
        $this
            ->getResponse ()
            ->setStatusCode (Response::STATUS_CODE_404);
    }
    /**
     * @return Router
     */
    protected function getRouter ()
    {
        if (!$this->router)
        {
            $this->router = Router::create ();
        }

        return $this->router;
    }
}