<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Presenter;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Order\Cart\Storage;
use MotoStore\Settings\Entity\Option;
use Zend\Http\PhpEnvironment\Request;

abstract class AbstractPresenter implements PresenterInterface
{
    /**
     * @var Request
     */
    protected $request;

    /**
     * @var
     */
    protected $collectionHelper;

    /**
     * @return Request
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param Request $request
     */
    public function setRequest($request)
    {
        $this->request = $request;
    }

    /**
     * @return \Zend\ServiceManager\ServiceLocatorInterface
     */
    protected function getServiceLocator ()
    {
        return SMStatic::getInstance ();
    }

    /**
     * Present Currency Object
     *
     * @param bool $fromSession
     * @return mixed
     */
    protected function presentCurrency ($fromSession = true, $currencyid = false)
    {
        $default = 0;

        if ($fromSession)
        {
            $storage = new Storage ();
            $default = $storage->getCurrency ();
        }

        $em = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager');



        if (!$default)
        {
            $default = $em
                ->getRepository('MotoStore\Settings\Entity\Option')
                ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'default_currency');
        }
        if ($currencyid){
            $default = $currencyid;
        }

        /** @var QueryBuilder $query */
        $currency = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->find ($default);

        return $currency;
    }

    /**
     * Display out of stock
     * @return int
     */
    protected function isDisplayOutOfStock ()
    {
        return $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'display_out_stock_product', 0);
    }

    /**
     * @return []
     */
    protected function getCurrencyList ()
    {
        return $this
            ->getServiceLocator ()
            ->get ('MotoStore\Settings\Entity\Currency')
            ->getActiveCurrenciesList ();
    }

}