<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;

use MotoStore\Content\Helper\Link;
use MotoStore\Content\Helper\Translator;
use MotoStore\Content\Plugin\Metatag;
use MotoStore\Content\Presenter\AccountPresenter;
use MotoStore\Platform\Controller\AbstractController;

class AccountController extends AbstractController
{
    const ACCOUNT_ORDERS    = 'orders';
    const ACCOUNT_DETAILS   = 'edit';

    /**
     * @param $uri
     */
    public function account ($uri)
    {

        if (!$this->getServiceLocator ()->get ('store.authentication.service')->getIdentity ())
        {
            Link::redirect ('login');
        }

        /** @var Metatag $metatag */
        $metatag = $this->getServiceLocator ()->get ('MotoStore\Plugin\Metatag');


        if ($this->page->title !== '')
        {
            $metatag->setTitle ($this->page->title);
        }
        elseif ($this->page->name !== '')
        {
            $metatag->setTitle ($this->page->name);
        }

    }

    /**
     * @return mixed
     */
    public function renderAccountPage ($widget)
    {
        $uri = Link::getEntityUri (Link::URI_SECTION_ACCOUNT);

        $presenter = new AccountPresenter ($uri);
        $presenter
            ->setRequest ($this->getRequest ());

        if ($this->getRequest()->isPost ())
        {
            $presenter->handle ();
        }

        $template = $uri == self::ACCOUNT_DETAILS
            ? 'store/account/account-edit.twig'
            : 'store/account/account-orders.twig';

        return $this->getServiceLocator ()
            ->get ('store.twig')
            ->render ($template, array_merge(array('currentWidget' => $widget),$presenter->present ()));
    }
}