<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;

use MotoStore\Content\Form\AuthenticationType;
use MotoStore\Content\Form\ForgotType;
use MotoStore\Content\Form\RegisterType;
use MotoStore\Content\Helper\Link;
use MotoStore\Customer\Entity\Customer;
use MotoStore\Mailer\Entity\Template;
use MotoStore\Platform\Auth\DoctrineAdapter;
use MotoStore\Platform\Controller\AbstractController;
use MotoStore\Content\Helper\Translator;
use Moto;


class AuthController extends AbstractController
{
    /**
     * Login Page Content
     * @return mixed
     */
    public function  login ()
    {
    }

    /**
     * Registration Page Content
     * @return mixed
     */
    public function register ()
    {

    }

    /**
     * @return mixed
     */
    public function forgot ()
    {
        
    }

    /**
     * @return mixed
     */
    public function renderRegisterForm ($currentWidget = null)
    {
        $errors = array ();
        $data = array ();

        if ($this->getServiceLocator ()->get ('store.authentication.service')->getIdentity ())
        {
            Link::redirect ('account', 'orders');
        }
        $additional_fields_errors = array();
        if ($this->getRequest()->isPost ())
        {
            $data = $this->getRequest ()->getPost ();

            $registration = new RegisterType ();
            $registration
                ->setEntityManager ($this->getServiceLocator ()->get ('MotoStore\EntityManager'))
                ->init ();

            $customer = new Customer ();
            $additional_fields_result = true;
            $additional_fields_process = false;
            $additional_fields_process = Moto\Hook::trigger('MOTOSTORE_HOOK_HANDLE_FORM_REGISTRATION_ADDITIONAL_FIELDS', $additional_fields_process ,$this->getRequest ()->getPost ());
            if (isset($additional_fields_process['success'])){
                $additional_fields_result = $additional_fields_process['success'];
                if(isset($additional_fields_process['errors'])){
                    $additional_fields_errors = $additional_fields_process['errors'];
                }
            }

            if ( $additional_fields_result && $registration->handle ($this->getRequest ()->getPost (), $customer))
            {
                $this
                    ->getServiceLocator ()
                    ->get ('store.mailer')
                    ->sendTemplate (
                        array ($customer->getEmail() => $customer->getFullName ()),
                        Template::TEMPLATE_TARGET_REGISTRATION,
                        array ('customer' => $customer, 'password' => $registration->getValue ('password'))
                    );

                Link::redirect ('login');
            }
            else
            {
                $errors = $registration->getMessages ();
            }
        }
        $after_form = Moto\Hook::trigger('MOTOSTORE_HOOK_DISPLAY_FORM_REGISTRATION_END', $additional_fields_errors);
        if (is_array($after_form)){
            $after_form = '';
        }
        $form =  $this->getServiceLocator ()
                    ->get ('store.twig')
                    ->render (
                        'store/auth/registration.twig',
                        array ('errors' => $errors, 'data' => $data, 'currentWidget' => $currentWidget)
                    );
        $form = str_replace('%{ DISPLAY_FORM_REGISTRATION_END }%', $after_form, $form);
        return $form;
    }
    
    
    /**
     * @return mixed
     */
    public function renderForgotForm ($currentWidget = null)
    {
        $errors     = array ();
        $success    = false;
        $data       = array ();


        if ($this->getRequest()->isPost ())
        {
            $data = $this->getRequest ()->getPost ();

            $forgot = new ForgotType ();

            $forgot
                ->init ()
                ->setData ($this->getRequest ()->getPost ());

            if ($forgot->isValid ())
            {
                $em = $this
                    ->getServiceLocator ()
                    ->get ('MotoStore\EntityManager');
                /**
                 * @var Customer $customer
                 */
                $customer = $em
                    ->getRepository ('MotoStore\Customer\Entity\Customer')
                    ->findOneBy (array (
                        'email' => $forgot->getValue ('email')
                    ));

                if ($customer)
                {
                    $password = DoctrineAdapter::generatePassword ();
                    $customer
                        ->setPassword (DoctrineAdapter::createPasswordHash ($customer->getEmail (), $password));

                    $em->merge ($customer);
                    $em->flush ();

                    $this
                        ->getServiceLocator ()
                        ->get ('store.mailer')
                        ->sendTemplate (
                            array ($customer->getEmail() => $customer->getFullName ()),
                            Template::TEMPLATE_TARGET_FORGOT_PASSWORD,
                            array (
                                'customer' => $customer,
                                'password' => $password
                            )
                        );

                    $success = true;
                }
                else
                {
                    $errors['email'] = array(Translator::translate ('AUTH_ACCOUNT_NOT_EXISTS', 'Account  does not exist'));
                }
            }
            else
            {
                $errors = $forgot->getMessages ();
            }
        }

        return $this->getServiceLocator ()
            ->get ('store.twig')
            ->render ('store/auth/forgot.twig', array (
                'errors' => $errors,
                'success' => $success,
                'data'  => $data,
                'currentWidget'=>$currentWidget
            ));
    }

    /**
     * @return mixed
     */
    public function renderAuthForm ($currentWidget = null)
    {
        $errors = array ();
        $data = array ();

        if ($this->getServiceLocator ()->get ('store.authentication.service')->getIdentity ())
        {
            Link::redirect ();
        }

        if ($this->getRequest()->isPost ())
        {
            $data = $this->getRequest ()->getPost ();

            $authentication = $this
                ->getServiceLocator ()
                ->get ('store.authentication.service');

            $form = new AuthenticationType ();
            $form->init ();

            $form->setData ($this->getRequest ()->getPost ());

            if ($form->isValid ())
            {
                $authentication
                    ->getAdapter()
                    ->setEmail ($form->getValue('email'))
                    ->setPassword ($form->getValue('password'));

                $result = $authentication->authenticate ();

                if ($result->isValid ())
                {
                    Link::redirect ();
                }
                $errors ['email'] = array (Translator::translate ('AUTH_INCORRECT_EMAIL_PASSWORD', 'Incorrect Email or Password'));
                $errors ['password'] = array (Translator::translate ('AUTH_INCORRECT_EMAIL_PASSWORD', 'Incorrect Email or Password'));
            }
            else
            {
                $errors = $form->getMessages ();
            }
        }

        return $this->getServiceLocator ()
            ->get ('store.twig')
            ->render ('store/auth/authorization.twig', array (
                'errors' => $errors,
                'data' => $data,
                'currentWidget'=>$currentWidget
            ));
    }
}