<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;

use MotoStore\Content\Helper\Translator;
use MotoStore\Content\Plugin\Metatag;
use MotoStore\Content\Presenter\CartPresenter;
use MotoStore\Platform\Controller\AbstractController;

class CartController extends AbstractController
{
    /**
     * Login Page Content
     * @return mixed
     */
    public function cart ($widget)
    {

        if ($this->page)
        {
            $this->page
                ->properties
                ->meta
                ->set ('robots', 'noindex, nofollow');
        }


        $presenter = new CartPresenter();
        $presenter
            ->setRequest ($this->getRequest ());

        if ($this->getRequest()->isPost ())
        {
            $presenter->handle ();
        }

        /** @var Metatag $metatag */
        $metatag = $this->getServiceLocator ()->get ('MotoStore\Plugin\Metatag');

        if (isset($this->page) && isset($this->page->title) && $this->page->title !== '')
        {
            $metatag->setTitle ($this->page->title);
        }
        elseif (isset($this->page) && isset($this->page->name) && $this->page->name !== '')
        {
            $metatag->setTitle ($this->page->name);
        }

        return $this->getServiceLocator ()
            ->get ('store.twig')
            ->render ('store/cart.twig', array_merge(array('currentWidget' => $widget),$presenter->present ()));
    }
}