<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;


use MotoStore\Content\Helper\Link;
use MotoStore\Content\Plugin\Metatag;
use MotoStore\Platform\Controller\AbstractController;
use MotoStore\Product\Entity\Category;

class CategoryController extends AbstractController
{
    public function category ($uri)
    {
        /** @var Category $category */
        $category = $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Category')
            ->getCategory ($uri);

        if ($category)
        {
            /** @var Metatag $metatag */
            $metatag = $this->getServiceLocator ()->get ('MotoStore\Plugin\Metatag');

            $metatag
                ->setTitle ($category->getLocaleByLanguageCode ('en')->getName ())
                ->setKeywords ($category->getLocaleByLanguageCode ('en')->getKeywords ())
                ->setDescription (strip_tags($category->getLocaleByLanguageCode ('en')->getMetaDescription ()))
                ->setCanonicalUrl( $category->getLocaleByLanguageCode ('en')->getCanonicalUrl ())
                ->setHideCanonical( $category->getLocaleByLanguageCode ('en')->getHideCanonical ())
                ->setMetaTitle( strip_tags($category->getLocaleByLanguageCode ('en')->getMetaTitle ()))
                ->setNoindex( $category->getLocaleByLanguageCode ('en')->getNoindex ())
                ->setNofollow( $category->getLocaleByLanguageCode ('en')->getNofollow ())
                ->setOgDescription(strip_tags($category->getLocaleByLanguageCode ('en')->getOgDescription()))
                ->setOgTitle(strip_tags($category->getLocaleByLanguageCode ('en')->getOgTitle()))
                ->setOgImage($category->getLocaleByLanguageCode ('en')->getOgImage() ? Link::imageLink ($category->getLocaleByLanguageCode ('en')->getOgImage(), false): '')
                ->setOgUrl ($category->getLocaleByLanguageCode ('en')->getOgUrl());

            $this->bindUrl ($category, Link::URI_SECTION_CATEGORY);
        }


    }

}