<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;

use MotoStore\Content\Helper\Translator;
use MotoStore\Content\Plugin\Metatag;
use MotoStore\Content\Presenter\ComparePresenter;
use MotoStore\Platform\Controller\AbstractController;

class CompareController extends AbstractController
{
    /**
     * Login Page Content
     * @return mixed
     */
    public function compare ($widget)
    {
        if ($this->page)
        {
            $this->page
                ->properties
                ->meta
                ->set ('robots', 'noindex, nofollow');
        }


        $presenter = new ComparePresenter();
        $presenter
            ->setRequest ($this->getRequest ());

        if ($this->getRequest()->isPost ())
        {
            $presenter->handle ();
        }


        $metatag = $this->getServiceLocator ()->get ('MotoStore\Plugin\Metatag');


        if ($this->page->title !== '')
        {
            $metatag->setTitle ($this->page->title);
        }
        elseif ($this->page->name !== '')
        {
            $metatag->setTitle ($this->page->name);
        }


        return $this->getServiceLocator ()
            ->get ('store.twig')
            ->render ('store/compare.twig', $presenter->present ($widget));

    }
}