<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;

use MotoStore\Platform\Controller\AbstractController;
use OAuth2;
use MotoStore\Settings\Entity\Option;
use Moto;
use MotoStore\Content\Content\DI\SMStatic;

class OauthQuickBooksController extends AbstractController
{

    const AUTHORIZATION_ENDPOINT = 'https://appcenter.intuit.com/connect/oauth2';
    const TOKEN_ENDPOINT         = 'https://appcenter.intuit.com/connect/oauth2';


    public function oauth ($uri)
    {
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $client_id=  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_client_id');
        $client_secret = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_client_secret');
        $client = new OAuth2\Client($client_id, $client_secret);

        if (!isset($_GET['code']))
        {
            $auth_url = $client->getAuthenticationUrl($this::AUTHORIZATION_ENDPOINT, Moto\System::getAbsoluteUrl('@website/store/oauth/quickbooks/'), array('scope'=> 'com.intuit.quickbooks.accounting', 'state'=>'security_token'));
            header('Location: ' . $auth_url);
            die('Redirect');
        }
        else
        {
            $http_headers['Authorization'] = 'Basic ' . base64_encode($client_id . ":" . $client_secret);
            $response = $client->executeRequest(
                'https://oauth.platform.intuit.com/oauth2/v1/tokens/bearer',
                array(
                    'code' => $_GET['code'],
                    'redirect_uri'=> Moto\System::getAbsoluteUrl('@website/store/oauth/quickbooks/'),
                    'grant_type' => 'authorization_code'
                ),
                "POST",
                $http_headers,
                0
            );
            $em = clone SMStatic::getInstance() ->get ('MotoStore\EntityManager');
            $result= isset($response['result'])?$response['result']:array();
            if ($result['access_token']){
                $option = new Option (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'quickbooks_access_token', $result['access_token']);
                $em->persist ($option);
            }
            $em->flush ();
            header('Location: ' . Moto\System::getAbsoluteUrl('@website/mt-admin/#!/store/settings/integrations'));
            die('Redirect');
        }
    }
}