<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Form;

use MotoStore\Content\Helper\Translator;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Platform\From\Validator\Unique;
use Zend\Validator\Between;
use Zend\Validator\NotEmpty;
use Zend\Validator\StringLength;
use Zend\Validator\Regex;
use MotoStore\Settings\Entity\Option;

class AddressType extends FormTypeAbstract
{
    protected $isNewAccountCreation = false;
    protected $notEmptymessage;
    protected $delivery_date_needed;
    protected $show_zip;
    protected $show_city;
    protected $show_state;
    protected $show_country;
    protected $show_company;
    protected $show_address2;
    protected $show_address;
    protected $show_lastname;
    protected $show_phone;

    public function __construct ($isNewAccountCreation = false)
    {
        $this->isNewAccountCreation = $isNewAccountCreation;
        /*@TODO:movetoproperplace*/
        $this->notEmptymessage = Translator::translate ('FORM_ERROR_REQUIRED', 'Value is required and can\'t be empty');
        $optRepository = SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $this->delivery_date_needed =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_delivery_time');
        $this->show_zip = $optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_zip');
        $this->show_city = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_city');
        $this->show_state = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_state');
        $this->show_country = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_country');
        $this->show_company = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_company');
        $this->show_address2 = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address2');
        $this->show_address = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address');
        $this->show_lastname = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_lastname');
        $this->show_phone = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_phone');
        parent::__construct ();
    }
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $default = new DefaultValue (1);
        $optRepository = SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $email = array (
            array (
                'name' => 'MotoStore\Platform\From\Validator\Email',
                'options' => array (
                    'domain' => false
                )
            ),
        );

        /**
         * For new account adjust password field and unique email validation 
         */
        if ($this->isNewAccountCreation)
        {
            $email [] = array (
                'name' => 'MotoStore\Platform\From\Validator\Unique',
                'options' => array (
                    'entityManager' => SMStatic::getInstance ()->get ('MotoStore\EntityManager'),
                    'entity'        => 'MotoStore\Customer\Entity\Customer',
                    'uniqueField'   => 'email',
                    'messages' => array (
                        Unique::NOT_UNIQUE   => 'This email already in use',
                    )
                )
            );

            $this->add (array (
                'name'      => 'password',
                'required'  => true,
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 6,
                            'max' => 255,
                        )
                    )
                ),
            ));
        }
        
        $this
            ->add (array (
                'name'      => 'active',
                'required'  => true,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'newsletter',
                'required'  => true,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'city',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                           'options' => array(
                               'max' => 255,
                               'messages'=> array (
                                   NotEmpty::IS_EMPTY => $this->notEmptymessage,
                               )
                           )

                    ),
                  /*  array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        ),
                    )
*/

                ),
            ))
            ->add (array (
                'name'      => 'email',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_email_required'),
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array_merge(array(array( 'name' => 'NotEmpty',
                                                                  'options' => array(
                                                                      'max' => 255,
                                                                      'messages'=> array (
                                                                          NotEmpty::IS_EMPTY => $this->notEmptymessage,
                                                                      )
                                                                  )

                )), $email)

            ))
            ->add (array (
                'name'      => 'first_name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                           'options' => array(
                               'max' => 255,
                               'messages'=> array (
                                   NotEmpty::IS_EMPTY => $this->notEmptymessage,
                               )
                           )
                ),
            )));
        if($this->show_lastname){
            $this->add (array (
                'name'      => 'last_name',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_lastname_required'),
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => $this->notEmptymessage,
                            )
                        )

                    )
                ),
            ));
        }

        if($this->show_company){
            $this->add (array (
                'name'      => 'company',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_company_required'),
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ));
        }
        if ($this->show_address){
            $this->add (array (
                'name'      => 'address1',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address_required'),
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    ),
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => $this->notEmptymessage,
                            )
                        )
                    )
                ),
            ));
        }
        if($this->show_address2){
            $this->add (array (
                'name'      => 'address2',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address2_required'),
                'filters' => array (
                    array('name' => 'StripTags'),
                    array('name' => 'StringTrim'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 255,
                        )
                    )
                ),
            ));
        }

        if ($this->show_zip){
            $this->add (array (
                'name'      => 'post_code',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_zip_required'),
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => $this->notEmptymessage,
                            )
                        )

                    ),
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'max' => 32,
                        )
                    ),
                    array(
                        'name' => 'Regex',
                        'options' => array(
                            'pattern' => '/^[a-z0-9-\s]*$/i',
                            'messages' => array (
                                Regex::NOT_MATCH => 'Invalid Zip/Postcode',
                            )
                        )
                    )
                ),
            ));
        }
        if($this->show_country){
            $this->add (array (
                'name'      => 'country',
                'required'  => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_country_required'),
                'validators'=> array (
                    array(
                        'name'    => 'Between',
                        'options' =>  array (
                            'min' => 1,
                            'messages' => array (
                                Between::NOT_BETWEEN        => $this->notEmptymessage,
                                Between::NOT_BETWEEN_STRICT => $this->notEmptymessage
                            )
                        ),
                    ),
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => $this->notEmptymessage,
                            )
                        )
                    )
                ),
            ));
        }
        if($this->show_state) {
            $this->add(array(
                'name' => 'state',
                'required' => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_state_required'),
                'filters' => array(
                    new DefaultValue (0),
                    array('name' => 'Digits')
                ),
                'validators' => array(),
            ));
        }
        if($this->show_phone) {
            $this->
            add(array(
                'name' => 'contact_phone',
                'required' => !!$optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_phone_required'),
                'validators' => array(
                    array('name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages' => array(
                                NotEmpty::IS_EMPTY => $this->notEmptymessage,
                            )
                        )

                    ),array(
                        'name' => 'Regex',
                        'options' => array(
                            'pattern' => '/\+?\d{5,20}/',
                            'messages'=> array (
                                Regex::NOT_MATCH => "Value doesn't seem to be a valid phone number",
                            )
                        ),
                    )
                ),
            ));
        }
        if($this->delivery_date_needed){
            $this->add (array (
                'name'      => 'delivery_date',
                'required'  => true,
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => $this->notEmptymessage,
                            )
                        )

                    )
                ),
            ));
        }

    }
}