<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;

use Moto;
use MotoStore\Product\Entity\Product;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Product\Entity\Variant;
use MotoStore\Order\Entity\Order;
use MotoStore\Collection\Query\Param;
use MotoStore\Settings\Repository\OptionRepository;
use MotoStore\Settings\Entity\Option;
use MotoStore\Payment\Gateway\PaymentModule;
use MotoStore\Payment\Gateway\Provider;
use DOMPDF;


class PDFGenerator
{

    public static function generateInvoice ($order_id= 1)
    {
        $collection = clone SMStatic::getInstance()
            ->get ('store.collection.order');
        $collection
            ->setFilters (array (
                new Param ('id', Param::OPERATOR_EQ, $order_id)
            ));
        $order = $collection
            ->getCollectionWithMetaData (function ($order) {

                $order['currencyid'] = $order['currency']['id'] ? $order['currency']['id'] : false;
                $order ['status_text'] = Order::getStatusName ($order ['status']);
                return $order;
            });
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $defaultCurrency = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'default_currency');
        if( $order ['collection'][0]['currencyid']){
            $defaultCurrency = $order['collection'][0]['currencyid'];
        }


        $dateFormat = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'date_format');
        if (!$dateFormat){
            $dateFormat = "Y-m-d";
        }
        $timeFormat = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'time_format');
        if (!$dateFormat){
            $timeFormat = "H:i:s";
        }

        $currency = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->find ($defaultCurrency);

        $image =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'invoiceImage');

        $designOptions = array(
            'image' => $image?Moto\System::getAbsolutePath("@userUploads/".$image):'',
            'themeColor'=>
                $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'themeHexColor')?
                    $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'themeHexColor'):
                    "#FFF",
            'invoiceTitle'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'invoiceTitle'),
            'companyName'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'companyName'),
            'companyAddress'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'companyAddress'),
            'phoneLabel'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'phoneLabel'),
            'companyPhone'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'companyPhone'),
            'companyEmail'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'companyEmail'),
            'footerText'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'footerText'),
            'footerTextBottom'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'footerTextBottom'),
            'show_order_id'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_order_id'),
            'show_payment_name'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_payment_name'),
            'show_customer_city'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_city'),
            'show_customer_state'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_state'),
            'show_customer_country'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_country'),
            'show_customer_address'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_address'),
            'show_customer_name'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_name'),
            'show_customer_email'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_email'),
            'show_customer_zip'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_zip'),
            'show_sku'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_sku'),
            'show_customer_phone'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_customer_phone'),
            'show_upc'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_upc'),
            'show_brand'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'show_brand'),
            'order_id'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'order_id'),
            'payment_gateway'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'payment_gateway'),
            'item_name'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'item_name'),
            'item_total'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'item_total'),
            'subtotal'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'subtotal'),
            'discount'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'discount'),
            'shippting_cost'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'shippting_cost'),
            'shippting_discount'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'shippting_discount'),
            'total'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'total'),
            'tax'=> $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INVOICES, 'tax'),
        );
        $order = $order ['collection'];
        $order = $order[0];
        $paymentProvider = SMStatic::getInstance ()
            ->get ('store.payment.provider');
        /**
         * @var PaymentModule $payment
         */
        $payment =  $paymentProvider
            ->getPaymentMethod ($order['payment_gateway']);
        if ($payment){
            $order['payment_gateway'] = $payment->getOption('display_name');
        }
        $renderArray =  array(
            'order'=>$order,
            'options' => $designOptions,
            'currency' => $currency,
            'dateFormat'=> $dateFormat .' '. $timeFormat
        );
        $dompdf = new DOMPDF();
        $renderer = clone SMStatic::getInstance()->get('store.twig');
        $html = $renderer->render ('store/invoice/template1.twig', $renderArray);
        $html = mb_convert_encoding ($html, "utf-8");
        $dompdf->load_html($html);
        $dompdf->render();
        $output = $dompdf->output();
        $globalConfig =  SMStatic::getInstance()->get('store.config');
        $exportdir = $globalConfig['settings']['exportPath'];
        $filename = $exportdir.'invoice-'.$order['order_id'].'.pdf';
        $relativeFilename =  Moto\System::getAbsoluteUrl($filename);
        file_put_contents(Moto\System::getAbsolutePath($filename), $output);

        return $relativeFilename;
    }
}