<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;


use MotoStore\Settings\Entity\Currency;

class Price
{
    /**
     * @param $price
     * @param Currency $currency
     * @return string
     */
    public static function decorate ($price, $currency = null)
    {
        if ($currency instanceof Currency)
        {
            return self::formatView ($price, $currency);
        }
        return self::defaultView ($price);
    }

    /**
     * Create Formated View
     *
     * @param $price
     * @param Currency $currency
     * @return string
     */
    protected static function formatView($price, Currency $currency)
    {
        $rated = $price * $currency->getExchangeRate ();

        $number = number_format (
            $rated, $currency->getDecimalPlaces (), $currency->getDecimalPoint (), $currency->getThousandsSeparator ()
        );

        if($currency->getSpacer() == '1' ||$currency->getSpacer() == 1 || $currency->getSpacer() == true){
            return $currency->getLocation() == \MotoStore\Settings\Entity\Currency::CURRENCY_LOCATION_LEFT
                ? $currency->getToken () . " " . $number
                : $number . " " .$currency->getToken ();

        }
        return $currency->getLocation() == \MotoStore\Settings\Entity\Currency::CURRENCY_LOCATION_LEFT
            ? $currency->getToken () . $number
            : $number . $currency->getToken ();

    }

    /**
     * Create Default Price View
     * @param $price
     * @return string
     */
    protected static function defaultView ($price)
    {
        return number_format ($price, 2, '.', ',');
    }

}