<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;

use Moto;
use Doctrine\DBAL\LockMode;
use Doctrine\ORM\EntityNotFoundException;
use Doctrine\ORM\EntityRepository;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Product\Entity\Category\Relation;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Variant;
use MotoStore\Product\Entity\Category;
use Zend\Db\Sql\Where as SqlWhere;
use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Repository\OptionRepository;

class Sitemap
{

    public static function generateProductsSitemap ()
    {
        $globalConfig = SMStatic::getInstance()->get('store.config');
        $settings = Moto\Website\SitemapService::getSettings();
        $setting_index = array_search('store.product', array_column($settings['content_preferences'], 'type'));
        if($setting_index){
            $priority = $settings['content_preferences'][$setting_index]['priority'];
            $changefreq = $settings['content_preferences'][$setting_index]['frequency'] ;
        } else {
            $priority = $globalConfig['settings']['sitemap']['productsPriority'];
            $changefreq = null;
        }

        $query = SMStatic::getInstance ()->get ('MotoStore\EntityManager')->createQueryBuilder ();
        $productList = $query
            ->select(array ('p'))
            ->from ('MotoStore\Product\Entity\Product', 'p')
            ->where ($query->expr ()->eq ('p.visibility', 1))
            ->getQuery ()
            ->getResult ();
        $sitemapdir = $globalConfig['settings']['sitemap']['path'];
        $sitemap = new Moto\Website\Sitemap\UrlSetFile();
        $sitemap->setFileName($sitemapdir.'products.xml');
        foreach ($productList as $k=>$product){
            if($product->getLocaleByLanguageCode ('en')->getNoindex ())
                continue;
            if($product->getLocaleByLanguageCode ('en')->getCanonicalUrl () && $product->getLocaleByLanguageCode ('en')->getCanonicalUrl () !== '')
                continue;
            $url = Moto\System::getAbsoluteUrl('@website/store/product/'.$product->getUri().'/');
            $lastmod = $product->getCreatedDate();
            $sitemap->addLocation($url, array(
                'lastmod' => date_format($lastmod,'Y-m-d'),
                'priority' => $priority,
                'changefreq' => $changefreq
            ));
        };
        $sitemap->write();
        return Moto\System::getAbsoluteUrl($sitemapdir.'products.xml');
    }
    public static function generateCategoriesSitemap ()
    {
        $globalConfig = SMStatic::getInstance()->get('store.config');
        $settings = Moto\Website\SitemapService::getSettings();
        $setting_index = array_search('store.category', array_column($settings['content_preferences'], 'type'));
        if($setting_index){
            $priority = $settings['content_preferences'][$setting_index]['priority'];
            $changefreq = $settings['content_preferences'][$setting_index]['frequency'] ;
        } else {
            $priority = $globalConfig['settings']['sitemap']['productsPriority'];
            $changefreq = null;
        }

        $query = SMStatic::getInstance ()->get ('MotoStore\EntityManager')->createQueryBuilder ();
        $categoryList = $query
            ->select(array ('c'))
            ->from ('MotoStore\Product\Entity\Category', 'c')
            ->getQuery ()
            ->getResult ();
        $sitemapdir = $globalConfig['settings']['sitemap']['path'];
        $sitemap = new Moto\Website\Sitemap\UrlSetFile();
        $sitemap->setFileName($sitemapdir.'categories.xml');
        foreach ($categoryList as $k=>$category){
            if($category->getLocaleByLanguageCode ('en')->getNoindex ())
                continue;

            if($category->getLocaleByLanguageCode ('en')->getCanonicalUrl () && $category->getLocaleByLanguageCode ('en')->getCanonicalUrl () !== '')
                continue;
            $url = Moto\System::getAbsoluteUrl('@website/store/category/'.$category->getUri().'/');
            $sitemap->addLocation($url, array(
                'priority' => $priority,
                'changefreq' => $changefreq
            ));
        };
        $sitemap->write();
        return Moto\System::getAbsoluteUrl($sitemapdir.'categories.xml');
    }

    public static function generatePagesSitemap ()
    {
        $globalConfig = SMStatic::getInstance()->get('store.config');
        $settings = Moto\Website\SitemapService::getSettings();
        $setting_index = array_search('store.mainpage', array_column($settings['content_preferences'], 'type'));
        if($setting_index){
            $priority = $settings['content_preferences'][$setting_index]['priority'];
            $changefreq = $settings['content_preferences'][$setting_index]['frequency'] ;
        } else {
            $priority = $globalConfig['settings']['sitemap']['mainpagePriority'];
            $changefreq = null;
        }
        $table = Moto\System::getDbTable('pages');
        $table->useResultAsModel(true);

        $where = new SqlWhere();
        // pages & posts
        $tempWhere = new SqlWhere();
        $tempWhere->addPredicates(array(
            'type' => array('template.store.home')
        ));
        $where->addPredicate($tempWhere, SqlWhere::COMBINED_BY_OR);
        $select = $table->createSelect();
        $select->where($where);
        $select->order(array('id' => 'ASC'));
        $items = $table->selectWith($select);
        $sitemapdir = $globalConfig['settings']['sitemap']['path'];
        $sitemap = new Moto\Website\Sitemap\UrlSetFile();
        $sitemap->setFileName($sitemapdir.'storepages.xml');
        foreach ($items as $item) {
            if (Moto\Util::getValue($item->properties, 'meta.canonical_url')) {
                continue;
            }
            if (Moto\Util::getValue($item->properties, 'meta.noindex')) {
                continue;
            }
            $modified = $item->modified;
             if (!empty($modified)) {
                 $modified = explode(' ', $modified);
                 $modified = $modified[0];
             }
            $url = Moto\System::getAbsoluteUrl('@website/store/');
            $sitemap->addLocation($url, array(
                'priority' => $priority,
                'lastmod' => $modified,
                'changefreq' => $changefreq
            ));
        };
        $sitemap->write();
        return Moto\System::getAbsoluteUrl($sitemapdir.'storepages.xml');
    }
    public static function generateSitemaps ()
    {
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $allow_index  = !$optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'noindex', false);
        if ($allow_index) {
            return array(static::generateProductsSitemap(),static::generateCategoriesSitemap(),static::generatePagesSitemap());
        } else {
            return array();
        }

    }
}