<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;


use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Settings\Entity\Option;

class Translator
{
    private static $translations = array ();

    public static function translate ($keyword, $default = null)
    {
        if (!self::$translations)
        {
            self::init();
        }


        if (!empty (self::$translations [$keyword]))
        {
            return self::$translations [$keyword];
        }
        return $default ? $default : $keyword;
    }

    public static function init ()
    {
        $translate = SMStatic::getInstance ()->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->getOption (Option::OPTION_STORE_SETTINGS_SYSTEM, 'localization', '');

        if ($translate)
        {
            self::$translations = json_decode ($translate, true);
        }
    }
}