<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Plugin;


use Moto\Application\Pages\PageModel;
use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Repository\OptionRepository;

class Metatag
{
    /**
     * @var OptionRepository
     */
    private $optionRepository;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $meta_title;

    /**
     * @var string
     */
    private $noindex;

    /**
     * @var string
     */
    private $nofollow;

    /**
     * @var string
     */
    private $canonical_url;

    /**
     * @var string
     */
    private $hide_canonical;

    /**
     * @var string
     */
    private $keywords;

    /**
     * @var string
     */
    private $description;

    /**
     * @var
     */
    private $allowIndexing;


    private $ogTitle;

    private $ogDescription;

    private $ogImage;

    private $ogUrl;

    private $jsonld;

    /**
     * Metatag constructor.
     * @param OptionRepository $optionRepository
     */
    public function __construct (OptionRepository $optionRepository)
    {
        $this->optionRepository = $optionRepository;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return string
     */
    public function getKeywords()
    {
        return $this->keywords;
    }

    /**
     * @param string $keywords
     * @return $this
     */
    public function setKeywords($keywords)
    {
        $this->keywords = $keywords;

        return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return OptionRepository
     */
    public function getOptionRepository()
    {
        return $this->optionRepository;
    }

    /**
     * @param OptionRepository $optionRepository
     */
    public function setOptionRepository($optionRepository)
    {
        $this->optionRepository = $optionRepository;
    }

    /**
     * @return mixed
     */
    public function getOgTitle()
    {
        return $this->ogTitle ? $this->ogTitle : $this->getTitle ();
    }

    /**
     * @param mixed $ogTitle
     * @return $this
     */
    public function setOgTitle($ogTitle)
    {
        $this->ogTitle = $ogTitle;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getOgDescription()
    {
        return $this->ogDescription;
    }

    /**
     * @param mixed $ogDescription
     * @return $this
     */
    public function setOgDescription($ogDescription)
    {
        $this->ogDescription = $ogDescription;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getOgImage()
    {
        return $this->ogImage;
    }

    /**
     * @param mixed $ogImage
     * @return $this
     */
    public function setOgImage($ogImage)
    {
        $this->ogImage = $ogImage;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getOgUrl()
    {
        return $this->ogUrl;
    }

    /**
     * @param mixed $ogUrl
     * @return $this
     */
    public function setOgUrl($ogUrl)
    {
        $this->ogUrl = $ogUrl;
        return $this;
    }
    /**
     * @return mixed
     */
    public function getJsonld()
    {
        return $this->jsonld;
    }

    /**
     * @param mixed $ogUrl
     * @return $this
     */
    public function setJsonld($data)
    {
        $this->jsonld = $data;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getMetaTitle()
    {
        return $this->meta_title;
    }

    /**
     * @param mixed $meta_title
     * @return $this
     */
    public function setMetaTitle($meta_title)
    {
        $this->meta_title = $meta_title;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getNoindex()
    {
        return $this->noindex;
    }

    /**
     * @param mixed $noindex
     * @return $this
     */
    public function setNoindex($noindex)
    {
        $this->noindex = $noindex;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getNofollow()
    {
        return $this->nofollow;
    }

    /**
     * @param mixed $nofollow
     * @return $this
     */
    public function setNofollow($nofollow)
    {
        $this->nofollow = $nofollow;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getHideCanonical()
    {
        return $this->hide_canonical;
    }

    /**
     * @param mixed $hide_canonical
     * @return $this
     */
    public function setHideCanonical($hide_canonical)
    {
        $this->hide_canonical = $hide_canonical;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCanonicalUrl()
    {
        return $this->canonical_url;
    }

    /**
     * @param mixed $canonical_url
     * @return $this
     */
    public function setCanonicalUrl($canonical_url)
    {
        $this->canonical_url = $canonical_url;
        return $this;
    }

    

    /**
     * @return mixed
     */
    public function getAllowIndexing()
    {
        if ($this->allowIndexing === null)
        {
            $this->allowIndexing = !$this->optionRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'noindex', false);
        }

        return $this->allowIndexing;

    }/**
     * @return mixed
     */
    public function inNoindexPages(PageModel $page)
    {
        $pageType = $page->type;
        $noidexPageTypes = array(
            'template.store.account',
            'template.store.cart',
            'template.store.checkout',
            'template.store.login',
            'template.store.register',
            'template.store.forgot',
            'template.store.compare'
        );

        return in_array($pageType,$noidexPageTypes);
    }

    /**
     * Apply metadata to page
     * @param PageModel $page
     */
    public function applyPageMetadata (PageModel $page)
    {

        if ($this->getMetaTitle())
        {
            $page
                ->set ('title', $this->getMetaTitle ());
        }
        elseif ($this->getTitle ())
        {
            $page
                ->set ('title', $this->getTitle ());
        }

        if ($this->getKeywords ())
        {
            $page
                ->properties
                ->meta
                ->set ('keywords', $this->getKeywords ());
        }

        if ($this->getDescription ())
        {
            $page
                ->properties
                ->meta
                ->set ('description', $this->getDescription ());
        }
        if($this->getHideCanonical()){
            $page
                ->properties
                ->meta
                ->set ('hideCanonical', true);
        } else {
            $page
                ->properties
                ->meta
                ->set ('hideCanonical', false);
        }

        if (!$this->getAllowIndexing () || $this->inNoindexPages($page) || ($this->getNofollow() && $this->getNoindex()))
        {
            $page
                ->properties
                ->meta
                ->set ('robots', 'noindex, nofollow');
            $page
                ->properties
                ->meta
                ->set ('hideCanonical', true);

        }
        elseif ($this->getNofollow())
        {
            $page
                ->properties
                ->meta
                ->set ('robots', 'nofollow');
        }
        elseif ($this->getNoindex())
        {
            $page
                ->properties
                ->meta
                ->set ('robots', 'noindex');
            $page
                ->properties
                ->meta
                ->set ('hideCanonical', true);
        }

        if($this->getCanonicalUrl()){
            $page
                ->properties
                ->meta
                ->set ('canonical_url', $this->getCanonicalUrl());
        }


    }

    public function attachMetaOgEvent (PageModel $page)
    {
        if (( $page->type == 'template.store.product' ||  $page->type == 'template.store.category' )){
            $title = $this->getOgTitle();
            $description = $this->getOgDescription();
            $image = $this->getOgImage();
            $url = $this->getOgUrl();


            $page
                ->properties
                ->meta
                ->set ('og', array(
                    'title'=>$title,
                    'image'=>$image,
                    'url'=>$url,
                    'description'=>$description,
                ));


        }
        if (( $page->type == 'template.store.product')){
            $code = $page->properties->custom_code->header;
            $page->properties->custom_code->set('header',$code.$this->getJsonld());
        }

        
    }


}