<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Widget;

use Moto\System\Widgets\AbstractWidget as AbstractMotoWidget;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Settings\Repository\OptionRepository;


class AbstractWidget extends AbstractMotoWidget
{
    /**
     * @var OptionRepository
     */
    private $optionsRepository;

    /**
     * @return OptionRepository
     */
    protected function getOptionsRepository ()
    {
        if (!$this->optionsRepository)
        {
            $this->optionsRepository = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Settings\Entity\Option');
        }
        return $this->optionsRepository;
    }


}