<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Localization\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class State implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {
        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('s'))
            ->from ('MotoStore\Localization\Entity\State', 's');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'code'   => 's.code',
            'name'   => 's.name',
        ));

        return $collection;
    }
}