<?php
/**
 * Created by PhpStorm.
 * User: olegk
 * Date: 2/8/15
 * Time: 12:18 AM
 */

namespace MotoStore\Localization\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class State
 * @package MotoStore\Localization\Entity
 * @ORM\Entity(readOnly=true)
 * @ORM\Table(name="store_state",options={"engine":"InnoDB"})
 */
class State
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @ORM\Column(type="integer")
     */
    protected $id;

    /**
     * @var int
     * @ORM\Column(type="integer")
     */
    protected $country_id;

    /**
     * @var string
     * @ORM\Column(type="string", length=10)
     */
    protected $code;

    /**
     * @var string
     * @ORM\Column(type="string")
     */
    protected $name;

    /**
     * @var Country
     * @ORM\ManyToOne(targetEntity="MotoStore\Localization\Entity\Country", inversedBy="states")
     * @ORM\JoinColumn(name="country_id", referencedColumnName="id")
     */
    protected $country;

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return int
     */
    public function getCountryId()
    {
        return $this->country_id;
    }

    /**
     * @param int $country_id
     * @return $this
     */
    public function setCountryId($country_id)
    {
        $this->country_id = $country_id;

        return $this;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Country
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param Country $country
     * @return $this
     */
    public function setCountry ($country)
    {
        $this->country = $country;

        return $this;
    }
}