<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Mailer\Collection;


use Doctrine\ORM\QueryBuilder;
use MotoStore\Collection\Collection;
use Zend\ServiceManager\FactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

class Template implements FactoryInterface
{
    /**
     * Create service
     *
     * @param ServiceLocatorInterface $serviceLocator
     * @return mixed
     */
    public function createService (ServiceLocatorInterface $serviceLocator)
    {

        $collection = new Collection ();

        /** @var QueryBuilder $queryBuilder */
        $queryBuilder = $serviceLocator
            ->get ('MotoStore\EntityManager')
            ->createQueryBuilder ();

        $query = $queryBuilder
            ->select (array ('t'))
            ->from ('MotoStore\Mailer\Entity\Template', 't')
            ->orderBy('t.show_priority', 'DESC');

        $collection->setQuery ($query);

        $collection->setPropertiesMap (array (
            'id' => 't.id',
            'name' => 't.name',
            'target' => 't.target',
            'type' => 't.type',
        ));

        return $collection;
    }
}